<?php
namespace BooklyLocations\Backend\Modules\Locations;

use Bookly\Backend\Components\Controls\Elements;
use Bookly\Lib as BooklyLib;

/**
 * Class Page
 * @package BooklyLocations\Backend\Modules\Locations
 */
class Page extends BooklyLib\Base\Component
{
    public static function render()
    {
        self::enqueueStyles( array(
            'bookly' => array(
                'backend/resources/bootstrap/css/bootstrap.min.css',
                'backend/resources/css/fontawesome-all.min.css',
                'frontend/resources/css/ladda.min.css',
            ),
        ) );

        self::enqueueScripts( array(
            'bookly' => array(
                'backend/resources/bootstrap/js/bootstrap.min.js' => array( 'jquery' ),
                'backend/resources/js/datatables.min.js'          => array( 'jquery' ),
                'backend/resources/js/dropdown.js'                => array( 'jquery' ),
                'frontend/resources/js/spin.min.js'               => array( 'jquery' ),
                'frontend/resources/js/ladda.min.js'              => array( 'jquery' ),
            ),
            'module' => array( 'js/locations.js' => array( 'bookly-dropdown.js' ), ),
        ) );

        $staff_collection = BooklyLib\Entities\Staff::query()->select( 'id, full_name' )->indexBy( 'id' )->fetchArray();

        $datatables = BooklyLib\Utils\Tables::getSettings( 'locations' );

        wp_localize_script( 'bookly-locations.js', 'BooklyL10n', array(
            'csrfToken'   => BooklyLib\Utils\Common::getCsrfToken(),
            'edit'        => esc_attr__( 'Edit', 'bookly' ),
            'areYouSure'  => esc_attr__( 'Are you sure?', 'bookly' ),
            'zeroRecords' => esc_attr__( 'No locations found.', 'bookly' ),
            'processing'  => esc_attr__( 'Processing...', 'bookly' ),
            'reorder'     => esc_attr__( 'Reorder', 'bookly' ),
            'staff'       => array(
                'allSelected'     => esc_attr__( 'All staff', 'bookly' ),
                'nothingSelected' => esc_attr__( 'No staff selected', 'bookly' ),
                'collection'      => $staff_collection,
            ),
            'datatables'  => $datatables,
        ) );

        $staff_dropdown_data = BooklyLib\Proxy\Pro::getStaffDataForDropDown();

        self::renderTemplate( 'index', compact( 'staff_dropdown_data', 'datatables' ) );
    }

}