<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly ?>

<div ng-hide="loading || form.screen != 'schedule'" class="modal-body">
    <div ng-show="form.schedule.items.length">
        <div class="alert alert-danger" ng-show="form.schedule.another_time.length">
            <span class="fas fa-info-circle text-primary fa-lg"></span>
            <?php esc_html_e( 'Some of the desired time slots are busy. System offers the nearest time slot instead. Click the Edit button to select another time if needed.', 'bookly' ) ?>
        </div>
        <ul id="bookly-schedule-items" class="list-group">
            <li class="list-group-item" ng-repeat="item in form.schedule.items | startFrom: schStartingItem() | limitTo: 10">
                <div class="row">
                    <div class="col-sm-1"><b>{{item.index}}</b></div>
                    <div class="col-sm-10 text-muted" ng-show="item.deleted">
                        <?php esc_html_e( 'Deleted', 'bookly' ) ?>
                    </div>
                    <div class="col-sm-1 text-right" ng-show="item.deleted">
                        <a href class="text-muted" title="<?php esc_attr_e( 'Restore', 'bookly' ) ?>"
                           ng-click="item.deleted = false">
                            <span class="fas fa-fw fa-undo"></span>
                        </a>
                    </div>
                    <div class="col-sm-3" ng-hide="item.deleted || form.schedule.edit == item.index">{{schFormatDate(item.date)}}</div>
                    <div class="col-sm-4" ng-if="form.schedule.edit == item.index">
                        <input date-range-picker type="text" class="form-control" autocomplete="off"
                               ng-model=item.date
                               options="{parentEl:'#bookly-appointment-dialog',item:item,singleDatePicker:true,showDropdowns:true,locale:schDatePickerOptions,eventHandlers:{'apply.daterangepicker':schOnChange}}"
                        />
                    </div>
                    <div class="col-sm-2" ng-hide="item.all_day_service_time || item.deleted || form.schedule.edit == item.index">{{schFormatTime(item.slots, item.options)}}</div>
                    <div class="col-sm-2" ng-show="item.all_day_service_time">{{item.all_day_service_time}}</div>
                    <div class="col-sm-3" ng-if="form.schedule.edit == item.index" ng-hide="item.all_day_service_time">
                        <select class="form-control custom-select" ng-model="item.slots"
                                ng-options="t.value as t.title disable when t.disabled for t in item.options"></select>
                    </div>
                    <div class="col-sm-4" ng-hide="item.deleted || form.schedule.edit == item.index">
                        <span ng-show="item.another_time">
                            <span class="fas fa-fw fa-exclamation-triangle text-warning mr-1"></span><?php esc_attr_e( 'Another time', 'bookly' ) ?>
                        </span>
                    </div>
                    <div class="col-sm-2 text-right" ng-hide="item.deleted || form.schedule.edit == item.index">
                        <a href class="far fa-fw fa-edit text-decoration-none" title="<?php esc_attr_e( 'Edit', 'bookly' ) ?>"
                           ng-click="form.schedule.edit = item.index; schOnDateChange(item);"></a>
                        <a href class="far fa-fw fa-trash-alt text-danger" title="<?php esc_attr_e( 'Delete', 'bookly' ) ?>"
                           ng-click="item.deleted = true"></a>
                    </div>
                    <div class="col-sm-4 text-right" ng-show="form.schedule.edit == item.index">
                        <a href class="fas fa-fw fa-check text-decoration-none" title="<?php esc_attr_e( 'Apply', 'bookly' ) ?>"
                           ng-show="form.schedule.edit == item.index"
                           ng-click="form.schedule.edit = 0"></a>
                    </div>
                </div>
            </li>
        </ul>
        <nav ng-show="schNumberOfPages() > 1">
            <ul class="pagination mt-3">
                <li ng-class="{'disabled': schFirstPage()}" class="page-item">
                    <a href ng-click="schPageBack()" class="page-link"><span>&laquo;</span></a>
                </li>
                <li ng-repeat="p in [] | range: schNumberOfPages()"
                    ng-class="{'active': form.schedule.page+1 == p}" class="page-item">
                    <a href ng-click="form.schedule.page = p - 1" class="page-link">{{p}}</a>
                </li>
                <li ng-class="{'disabled': schLastPage()}" class="page-item">
                    <a href ng-click="schPageForward()" class="page-link"><span>&raquo;</span></a>
                </li>
            </ul>
        </nav>
        <div class="alert alert-danger" ng-show="form.schedule.another_time.length && schNumberOfPages() > 1">
            <span class="fas fa-fw fa-exclamation-triangle text-warning fa-lg mr-2"></span><?php esc_html_e( 'Another time was offered on pages', 'bookly' )?>
            {{form.schedule.another_time.join(', ')}}.
        </div>
    </div>
</div>