<?php if (!defined('ABSPATH')) { exit; } // Exit if accessed directly
/**
 * Simple_Job_Board_CAPTCHA_Ajax Class
 *
 * This file includes the ajax call for:
 * 
 *  - Verifying goole reCAPTCHA response
 * 
 * @link        https://wordpress.org/plugins/simple-job-board
 * @since       2.3.2
 *
 * @package     Simple_Job_Board_CAPTCHA
 * @subpackage  Simple_Job_Board_CAPTCHA/includes
 * @author      PressTigers <support@presstigers.com>
 */

class Simple_Job_Board_CAPTCHA_Ajax {

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $simple_job_board    The ID of this plugin.
     */
    private $failure_error;

    /**
     * Constructor
     */
    public function __construct() {

        $this->failure_error = '';

        // Action - Validate reCAPTCHA Response on Form Submission
        add_action('sjb_uploaded_resume_validation', array($this, 'recaptcha_validation'), 0);

        // Filter - Override Default SJB Plugin Failure Message
        add_filter('sjb_job_not_submitted_alert', array($this, 'sjb_failure_error'));
    }

    /**
     * Validate reCAPTCHA Response
     *
     * @access public
     * @return void
     */
    public function recaptcha_validation() {

        // Verify Response
        if (!empty($_POST['g-recaptcha-response'])) {
            $recaptcha = get_option('job_board_recaptcha');

            // API KEYS Existance in Settings
            if ('' != trim($recaptcha['site_key']) && '' != trim($recaptcha['secret_key'])) {
                $params = array(
                    'secret' => esc_attr( trim($recaptcha['secret_key'] ) ),
                    'response' => esc_attr( $_POST['g-recaptcha-response'] ),
                );

                // Remote URL
                $url = 'https://www.google.com/recaptcha/api/siteverify?' . http_build_query($params);
                $response = wp_remote_get($url);
                $json_response = json_decode( wp_remote_retrieve_body($response), TRUE );
                
                // Success Response
                if ( TRUE == $json_response["success"] ) {
                    return;
                } /* Failure Response */else {
                    $this->failure_error('<div class="clearfix"></div><div class="alert alert-danger">' . __('reCAPTCHA verification failed.', 'simple-job-board-captcha') );
                    $error_reponse = json_encode(array('success' => FALSE, 'error' => $this->get_error()));
                    header("Content-Type: application/json");
                    echo $error_reponse;
                    wp_die();
                }
            } /* Missing API KEYS in Settings */ else {
                $this->failure_error('<div class="clearfix"></div><div class="alert alert-danger">' . __('Empty reCAPTCHA API keys! Please enter reCAPTCHA API keys in Job Board settings.', 'simple-job-board-captcha') );
                $error_reponse = json_encode(array('success' => FALSE, 'error' => $this->get_error()));
                header("Content-Type: application/json");
                echo $error_reponse;
                wp_die();
            }
        } /* Verification CAPTCHA */ else {
            $this->failure_error('<div class="clearfix"></div><div class="alert alert-danger">' . __('Please pass reCAPTCHA verification.', 'simple-job-board-captcha') );
            $error_reponse = json_encode(array('success' => FALSE, 'error' => $this->get_error()));
            header("Content-Type: application/json");
            echo $error_reponse;
            wp_die();
        }
    }

    /**
     * Override SJB Default Error Message.
     * 
     * @since   2.3.2
     * 
     * @param   string  $error
     * @return  string  $error
     */
    public function sjb_failure_error($error) {
        $error = '';
        return $error;
    }

    /**
     * Set reCAPTCHA Error Message.
     * 
     * @since   2.3.2
     * 
     * @param   string  $error
     * @return  void
     */
    public function failure_error( $error ) {
        $this->failure_error = $error;
    }

    /**
     * Set reCAPTCHA Error Message.
     * 
     * @since   2.3.2
     * 
     * @return  $this->failure_error    reCAPTCHA Error
     */
    public function get_error() {
        return $this->failure_error;
    }

}

new Simple_Job_Board_CAPTCHA_Ajax();