<?php if (!defined('ABSPATH')){ exit; } // Exit if accessed directly
/**
 * Simple_Job_Board_Email_Attachment_Settings Class
 * 
 * This is used to add fields in email notifications setting section 
 * to enble/disable email attachment.
 *
 * @link        https://wordpress.org/plugins/simple-job-board
 * @since       2.2.2
 * 
 * @package     Simple_Job_Board_Email_Attachment
 * @subpackage  Simple_Job_Board_Email_Attachment/admin
 * @author      PressTigers <support@presstigers.com>
 */

class Simple_Job_Board_Email_Attachment_Settings {

    /**
     * Initialize the class and set its properties.
     *
     * @since   1.0.0
     */
    public function __construct() {

        // Action -> Add Settings for Resume Attachment
        add_action( 'sjb_notifications_settings_end', array($this, 'sjbea_resume_attachment_settings_fields'), 10 );

        // Action -> Add Settings for Applicant Details' Attachment
        add_action( 'sjb_notifications_settings_end', array($this, 'sjbea_applicant_details_settings_fields'), 20 );
        
        // Filter -> Add Settings for Multiple HR's Email Addresses
        add_filter( 'sjb_settings_hr_email', array( $this, 'hr_emails' ) );
    }

    /**
     * Add Settings for Resume Attachment.
     *
     * @since  2.2.2
     */
    public function sjbea_resume_attachment_settings_fields() {
        if ( isset($_POST) and count($_POST) > 0 ) {
            if ( isset($_POST['job_board_admin_email_attachment'] ) || isset( $_POST['job_board_hr_email_attachment'] ) || isset($_POST['job_board_author_email_attachment'] )) {
                if ( isset( $_POST['job_board_admin_email_attachment'] ) ) {
                    update_option( 'job_board_admin_email_attachment', $_POST['job_board_admin_email_attachment'] );
                }
                
                if ( isset( $_POST['job_board_hr_email_attachment'] ) ) {
                    update_option( 'job_board_hr_email_attachment', $_POST['job_board_hr_email_attachment'] );
                }
                
                if ( isset( $_POST['job_board_author_email'] ) ) {
                    update_option( 'job_board_author_email', $_POST['job_board_author_email'] );
                }
                if ( isset( $_POST['job_board_author_email_attachment'] ) ) {
                    update_option( 'job_board_author_email_attachment', $_POST['job_board_author_email_attachment'] );
                }
            }
        }
        
        $author_email = get_option('job_board_author_email') ? get_option('job_board_author_email') : 'yes';
        $admin_email_attachment = get_option('job_board_admin_email_attachment') ? get_option('job_board_admin_email_attachment') : 'yes';
        $hr_email_attachment = get_option('job_board_hr_email_attachment') ? get_option('job_board_hr_email_attachment') : 'yes';
        $author_email_attachment = get_option('job_board_author_email_attachment') ? get_option('job_board_author_email_attachment') : 'yes';
        
        echo '<div class="sjb-form-group right-align">
                <input type="hidden" name="job_board_author_email" value="no" />
                <input type="checkbox" name="job_board_author_email" value="yes" ' . checked( $author_email, "yes", FALSE ) . '/>'
                . ''. __("Enable the Job Author Email Notification", "simple-job-board-email-attachment") . '
              </div>';
        
        echo '<div class="sjb-form-group">
               <label>' . __("Attachment(s):", "simple-job-board-email-attachment") . ' </label>
                   <input type="hidden" name="job_board_admin_email_attachment" value="no" />
                   <input type="checkbox" name="job_board_admin_email_attachment" value="yes" ' . checked($admin_email_attachment, "yes", FALSE ) . '/>'
                . '' . __("Enable Attachment(s) for Admin Email", "simple-job-board-email-attachment") . '
              </div>
             <div class="sjb-form-group right-align">                
                <input type="hidden" name="job_board_hr_email_attachment" value="no" />
                <input type="checkbox" name="job_board_hr_email_attachment" value="yes" ' . checked($hr_email_attachment, "yes", FALSE) . '/>'
                . '' . __("Enable Attachment(s) for HR Email", "simple-job-board-email-attachment") . '
             </div>
             <div class="sjb-form-group right-align">                
                <input type="hidden" name="job_board_author_email_attachment" value="no" />
                <input type="checkbox" name="job_board_author_email_attachment" value="yes" ' . checked($author_email_attachment, "yes", FALSE) . '/>'
                . '' . __("Enable Attachment(s) for Author Email", "simple-job-board-email-attachment") . '
             </div>';
    }

    /**
     * Add Settings for Applicant Details Section.
     *
     * @since   2.2.2  
     */
    public function sjbea_applicant_details_settings_fields() {
        if ( isset($_POST) and count($_POST) > 0 ) {
            if ( isset($_POST['job_board_admin_email_parameters'] ) || isset( $_POST['job_board_hr_email_parameters'] ) || isset($_POST['job_board_author_email_parameters'] ) ) {
                
                if ( isset( $_POST['job_board_admin_email_parameters'] ) ) {
                    update_option( 'job_board_admin_email_parameters', $_POST['job_board_admin_email_parameters'] );
                }
                
                if ( isset( $_POST['job_board_hr_email_parameters'] ) ) {
                    update_option( 'job_board_hr_email_parameters', $_POST['job_board_hr_email_parameters'] );
                }
                
                if ( isset( $_POST['job_board_author_email_parameters'] ) ) {
                    update_option( 'job_board_author_email_parameters', $_POST['job_board_author_email_parameters'] );
                }
            }
        }

        $admin_email_parameters = get_option('job_board_admin_email_parameters') ? get_option('job_board_admin_email_parameters') : 'yes';
        $hr_email_parameters = get_option('job_board_hr_email_parameters') ? get_option('job_board_hr_email_parameters') : 'yes';
        $author_email_parameters = get_option('job_board_hr_email_parameters') ? get_option('job_board_author_email_parameters') : 'yes';
        
        echo '<div class="sjb-form-group">
              <label> ' . __("Applicant Details:", "simple-job-board-email-attachment") . ' </label> 
                  <input type="hidden" name="job_board_admin_email_parameters" value="no" /><input type="checkbox" name="job_board_admin_email_parameters" value="yes" ' . checked($admin_email_parameters, "yes", FALSE ) . '/>' . __("Enable Applicant Details for Admin Email", "simple-job-board-email-attachment") . '
              </div>
              <div class="sjb-form-group right-align">
                <input type="hidden" name="job_board_hr_email_parameters" value="no" /><input type="checkbox" name="job_board_hr_email_parameters" value="yes" ' . checked($hr_email_parameters, "yes", FALSE ) . '/>' . __("Enable Applicant Details for HR Email", "simple-job-board-email-attachment") . '
              </div>
              <div class="sjb-form-group right-align">
                <input type="hidden" name="job_board_author_email_parameters" value="no" /><input type="checkbox" name="job_board_author_email_parameters" value="yes" ' . checked($author_email_parameters, "yes", FALSE ) . '/>' . __("Enable Applicant Details for Author Email", "simple-job-board-email-attachment") . '
              </div>';
    }
    
    /**
     * Add Settings for Multiple HR's Email Addresses.
     *
     * @since   2.3.2
     * 
     * @param   string  $email  HR Email Address 
     * @return  string  $email  Modified HR Email Address
     */
    public function hr_emails( $email ) {
        
        // Save Option
        if ( !empty( $_POST['hr_emails'] ) ) {
            ( FALSE !== get_option('settings_hr_emails') ) ? 
                update_option( 'settings_hr_emails', sanitize_text_field( $_POST['hr_emails'] ) ) :
                add_option( 'settings_hr_emails', sanitize_text_field( $_POST['hr_emails'] ) );    
        }
        
        // Get HR Email
        $hr_email = ( FALSE !== get_option('settings_hr_emails') ) ?  get_option( 'settings_hr_emails' ) : get_option( 'settings_hr_email' );
        $email = '<div class="input-caption"><input type="text" name="hr_emails" value="' . $hr_email . '" >'
                . '<span>Add emails seprated by space or comma e.g. <b>support@presstigers.com fahad@presstigers.com</b> or <b>support@presstigers.com, fahad@presstigers.com</b></span></div>';
        return $email;
    }

}

new Simple_Job_Board_Email_Attachment_Settings();