<?php
/**
 * The admin-specific functionality of the plugin.
 * 
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @link       http://presstigers.com/
 * @since      2.4.3
 *
 * @package    Sjb_Job_Expirator
 * @subpackage Sjb_Job_Expirator/admin
 * @author     PressTigers <support@presstigers.com>
 */
class Sjb_Job_Expirator_Admin {

    /**
     * The ID of this plugin.
     *
     * @since    2.4.3
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    2.4.3
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    2.4.3
     * @param      string    $plugin_name       The name of this plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version) {

        $this->plugin_name = $plugin_name;
        $this->version = $version;

        /**
         * The class responsible for adding custom post statuses in the admin area.
         */
        require_once plugin_dir_path(dirname(__FILE__)) . 'admin/class-sjb-job-expirator-meta-box.php';
        
        /**
         * The class responsible for adding custom post statuses in the admin area.
         */
        require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-sjb-job-expirator-expire-job-postings.php';
    }

    /**
     * Register the stylesheets for the admin area.
     *
     * @since    2.4.3
     */
    public function enqueue_styles() {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Sjb_Job_Expirator_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Sjb_Job_Expirator_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/sjb-job-expirator-admin.css', array(), $this->version, 'all');
    }

    /**
     * Register the JavaScript for the admin area.
     *
     * @since    2.4.3
     */
    public function enqueue_scripts() {

        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Sjb_Job_Expirator_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Sjb_Job_Expirator_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/sjb-job-expirator-admin.js', array('jquery', 'jquery-ui-datepicker'), $this->version, false);
    }

}
