<?php
/**
 * SJB_Job_Expirator_Expire_Job_Postings Class
 * 
 * @link       http://presstigers.com/
 * @since      2.4.2
 *
 * @package    Simple_Job_Board_Bee_Recruitment
 * @subpackage Simple_Job_Board_Bee_Recruitment/admin
 * @author     PressTigers <support@presstigers.com>
 */
class SJB_Job_Expirator_Expire_Job_Postings {

    /**
     * Initialize class constructor
     * 
     * @since   2.4.2
     */
    public function __construct() {

        // Add Custom Post Status
        add_action('init', array($this, 'register_custom_post_status'));
        
        // Expire Job Postings
        add_action('init', array($this, 'expire_job_postings'));
        
        // Add Unpublish Status in Save Meta Box
        add_action('post_submitbox_misc_actions', array($this, 'display_post_status'));
    }

    /**
     * Add Custom Post Status
     *
     * @since   2.4.2
     */
    public function register_custom_post_status() {

        register_post_status('unpublished', array(
            'label' => _x('Unpublished', 'simple-job-board-bee-recruitment'),
            'public' => TRUE,
            'show_in_admin_all_list' => FALSE,
            'show_in_admin_status_list' => TRUE,
            'label_count' => _n_noop('Unpublished <span class="count">(%s)</span>', 'Unpublished <span class="count">(%s)</span>')
        ));
    }

    /**
     * Save Additional Profile Fields
     * 
     * @since    2.4.3
     *
     * @param  int $user_id Current user ID.
     */
    public function display_post_status() {

        // Check for user privilage
        global $post;

        //only when editing a post
        if ($post->post_type == 'jobpost') {

            // custom post status: approved
            $selected = '';
            $label = '';

            if ($post->post_status == 'unpublished') {
                $selected = 'selected=\"selected\"';
                $label = '<span id=\"post-status-display\">' . __( 'Unpublished','simple-job-board-bee-recruitment' ) .'</span>';
                
                // Script to show "Unpublished" status for a post
                echo '<script>' .
                'jQuery(document).ready(function($){' .            
                '$("#post-status-display").text("Unpublished");' .            
                '});' .
                '</script>';
            }
            
            // Script to add "Unpublished" status to status dropdown
            echo '<script>' .
            'jQuery(document).ready(function($){' .
            '$("select#post_status").append(' .
            '"<option value=\"unpublished\" ' . esc_attr( $selected ). '>' .
            'Unpublished' .
            '</option>"' .
            ');' .            
            '});' .
            '</script>';
        }
    }

    /**
     * Expire Job Listing on its expiry date
     * 
     * @since    2.4.3
     */
    public function expire_job_postings() {
        
        // Get access to the current WordPress object instance
        global $wpdb;
        
        // Get Id's of all job posts
        $querystr = "
            SELECT $wpdb->posts.ID 
            FROM $wpdb->posts
            WHERE 
            $wpdb->posts.post_type = 'jobpost'";
        
        // Return ID's as an Object Type
        $jobpost_ids = $wpdb->get_results( $querystr, OBJECT );
        
        // Check job expiry date
        foreach ( $jobpost_ids as $job ) {
            $expiry_flag = get_post_meta( $job->ID, 'sjb_job_expiry_flag', TRUE );
            
            // If job expirator is enabled & expiry date is set
            if ( $expiry_flag && 'checked' == $expiry_flag ) {

                // Retrieve job expiry date            
                if (( '' != get_post_meta($job->ID, 'sjb_job_expirator', TRUE) ) && 'publish' === get_post_status( $job->ID ) ) {
                    $expiration_date = get_post_meta($job->ID, 'sjb_job_expirator', TRUE);

                    if ($expiration_date < time()) {
                        $post = array('ID' => $job->ID, 'post_status' => 'unpublished');
                        wp_update_post($post);
                    }
                    
                } /* If job expirator is enabled & expiry date is not set */ elseif ('publish' === get_post_status($job->ID)) {
                    $daystogo = '30';
                    $sql = "UPDATE {$wpdb->posts}
                    SET post_status = 'unpublished'
                    WHERE (post_type = 'jobpost' AND post_status = 'publish')
                    AND DATEDIFF( NOW(), post_date ) > %d";
                    $wpdb->query($wpdb->prepare( $sql, $daystogo ) );
                }
            }
        }
    }
}
new SJB_Job_Expirator_Expire_Job_Postings();