<?php
/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @link       http://presstigers.com/
 * @since      2.4.3
 *
 * @package    Sjb_Job_Expirator
 * @subpackage Sjb_Job_Expirator/public
 * @author     PressTigers <support@presstigers.com>
 */
class Sjb_Job_Expirator_Public {

    /**
     * The ID of this plugin.
     *
     * @since    2.4.3
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    2.4.3
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;

    /**
     * Initialize the class and set its properties.
     *
     * @since    2.4.3
     * @param      string    $plugin_name       The name of the plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version) {

        $this->plugin_name = $plugin_name;
        $this->version = $version;
        
        // Filter -> Job Argument -> Replace Job Application Template with Author's Details
        add_filter('sjb_output_jobs_args', array($this, 'add_sjb_output_arg'));
    }

    /**
     * Register the stylesheets for the public-facing side of the site.
     *
     * @since    2.4.3
     */
    public function enqueue_styles() {

        // Enqueue Front-end Styles
        wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/sjb-job-expirator-public.css', array(), $this->version, 'all');
    }

    /**
     * Register the JavaScript for the public-facing side of the site.
     *
     * @since    2.4.3
     */
    public function enqueue_scripts() {

        // Enqueue Front-end Scripts
        wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/sjb-job-expirator-public.js', array('jquery'), $this->version, false);
    }
    
    /**
     * Add job status in query arguments array
     * 
     * @since    2.4.2
     * 
     * @param   $arg    Job Query Argument Array
     * @param   $arg    Add Post Status to Job Query
     */
    public function add_sjb_output_arg($arg) {
        $arg['post_status'] = 'publish';
        return $arg;
    }
}