    <?php
    global $wpdb, $current_user;
    $wpttarUserRole = $this->WPTTARGetCurrentUserCall();
    if (isset($_REQUEST['developerID']) && !empty($_REQUEST['developerID'])) {
        $developerID = $_REQUEST['developerID'];
    } else {
        $developerID = $current_user->ID;
    }
    $wpttarMembersResults = $this->WPTTARGetResultsByID($developerID, $this->WpttarTeamsTable, 'teamMember');
    $WpttarEmployeeFirstName = get_user_meta($developerID, 'first_name', true);
    $WpttarEmployeeLastName = get_user_meta($developerID, 'last_name', true);
    $wpttarGetPagePermissions = $this->WPTTARGetPagePermissions();
    wp_enqueue_style('wpttar-datepicker3-css');
    ?>
    <!-- BEGIN PAGE HEADER-->
    <!-- END PAGE HEADER-->
    <!-- BEGIN PAGE CONTENT-->
    <div class="preloader">  <span class="preloader-custom-gif"></span></div>
    <input type="hidden" id="current-role-member" value="<?php echo $wpttarUserRole; ?>">
    <div style="padding-left: 0px; padding-right:20px; padding-top:0px;" class="col-md-12">
        <h3 class="page-title"><?php _e('Developer Projects', 'wpttar'); ?></h3>
        <div class="page-bar">
            <ul class="page-breadcrumb">
               <li><a href="?page=wpttar-projects"><i class="fa fa-home"></i><?php _e('Home', 'wpttar'); ?><i class="fa fa-angle-right"></i></a></li>
                <li><?php _e('Developer Projects', 'wpttar'); ?></li>        
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                 <?php if (in_array('manage_options_projects', $wpttarGetPagePermissions)) {  ?>
                <?php if (isset($_REQUEST['mypage']) && $_REQUEST['mypage'] = 'viewpage') { ?>
                <a class="btn green " href="?page=wpttar-project-view&projectID=<?php if (isset($_REQUEST['projectID'])) { echo esc_attr($_REQUEST['projectID']); } ?>" ><i class="fa fa-arrow-left"></i><?php _e('Back', 'wpttar'); ?> </a>
                 <?php } else { ?>
                <a class="btn green " href="?page=wpttar-development-team" ><i class="fa fa-arrow-left"></i><?php _e('Back', 'wpttar'); ?> </a>
                 <?php } } ?>
                <div class="portlet box blue calendar">
                    <div class="portlet-title">
                        <div class="caption">
                            <i class="fa fa-list"></i>
                            <?php
                            if (isset($WpttarEmployeeFirstName)) : echo esc_html($WpttarEmployeeFirstName . ' ');
                            endif;
                            if (isset($WpttarEmployeeLastName)) : echo esc_html($WpttarEmployeeLastName);
                            endif;
                            ?>
                        </div>
                        <div class="actions" style="margin-right: -6px;">
                            <input form="wpttar-project-reports" style="padding :7px 13px; height: 29px;" placeholder="<?php _e('From Date', 'wpttar'); ?> " data-date-format="dd-mm-yyyy" id="from-date" name="from-date" class="date-picker form-control input-inline">
                            <input form="wpttar-project-reports" style="padding :7px 13px; margin-right: 12px; height: 29px;" placeholder="<?php _e('To Date', 'wpttar'); ?>" data-date-format="dd-mm-yyyy" name="to-date" id="to-date" class="date-picker form-control input-inline">

                            <a href="javascript:;"  onclick="WPTTARprojectsReport('Wpttar-developer-pdf-reports', 'developer-projects-list')" data-loading-text="Updating..."  class="demo-loading-btn btn btn-sm red">
                                <i class="fa fa-download" ></i><?php _e('PDF', 'Wpttar'); ?>
                            </a>
                            <a href="javascript:;"  onclick="WPTTARprojectsReport('Wpttar-developer-excel-reports', 'developer-projects-list')" data-loading-text="Updating..."  class="demo-loading-btn btn btn-sm yellow">
                                <i class="fa fa-download" ></i><?php _e('Excel', 'Wpttar'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="portlet-body">
                        <form name="wpttar-project-reports" id="wpttar-project-reports" action="?page=wpttar-projects-reports" method="post">
                            <div class="col-md-12 col-sm-12 project-report-msg"></div>
                                <input type="hidden" name="wpttar-report-type" value="" id="wpttar-report-type" class="wpttar-report-type" />
                                <input type="hidden" name="wpttar-report-action" value="" id="wpttar-report-action" class="wpttar-report-action" />
                                <input type="hidden" name="wpttar-developer-id" value="<?php
                                if (isset($developerID)) : echo esc_attr($developerID);
                                endif;
                                ?>" id="wpttar-developer-id" class="wpttar-developer-id" />
                        </form>
                        <table class="table table-striped table-bordered table-hover" id="wpttarDataTable">
                            <thead>
                                <tr>
                                    <th><?php _e('S.No', 'wpttar'); ?></th>
                                    <th><?php _e('Project Name', 'wpttar'); ?></th>
                                     <th><?php _e('Project added Date', 'wpttar'); ?></th>
                                    <th><?php _e('Start Date', 'wpttar'); ?></th>
                                    <th><?php _e('End Date', 'wpttar'); ?></th>
                                    <th><?php _e('Total Time', 'wpttar'); ?></th>
                                    <th><?php _e('Day Wise Log', 'wpttar'); ?></th>
                                    <th><?php _e('Comments', 'wpttar'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                if (!empty($wpttarMembersResults)) {
                                    foreach ($wpttarMembersResults as $wpttarMembersResult) {
                                        $wpttarProjectResults = $this->WPTTARGetTableDataByID($wpttarMembersResult->projectID, $this->WpttarProjectsTable, 'id');
                                        $wpttarProjectDates = $this->WPTTARGetResultsByOrderByFieldName($this->WpttarProjectsLogTable,'projectID',$wpttarMembersResult->projectID,'updateDate','ASC','getRow');

                                        $wpttarProjectHours = $this->WPTTARGetResultsByMultipleFields($this->WpttarProjectsLogTable,'projectID','developerID',$wpttarMembersResult->projectID,$developerID,'getResults'); 
                                        $getTotalHour = $this->WPTTARGetProjectTime($wpttarProjectHours, 'totalHours');
                                        if(!empty($wpttarProjectResults)){
                                        ?>
                                        <tr id="row">
                                            <td><?php echo esc_html($i); ?></td>

                                                <?php if (in_array('manage_options_projects', $wpttarGetPagePermissions)) { ?> 
                                                <td ><?php
                                                    if (isset($wpttarProjectResults->projectName)) : echo esc_html($wpttarProjectResults->projectName);
                                                    endif;
                                                    ?></td>
                                                <?php } else { ?> 
                                                <td class="text-center"><a  href="?page=wpttar-project-view&projectID=<?php
                                                    if (isset($wpttarProjectResults->id)) : echo esc_html($wpttarProjectResults->id);
                                                    endif;
                                                    ?>&graphType=DayWise"><?php
                                                                                if (isset($wpttarProjectResults->projectName)) : echo esc_html($wpttarProjectResults->projectName);
                                                                                endif;
                                                                                ?></a></td>
                                                <?php } ?>

                                            <td><?php
                                                if (isset($wpttarProjectResults->dateTime)) : echo esc_html(date('d-m-Y', strtotime($wpttarProjectResults->dateTime)));
                                                endif;
                                                ?></td>
                                             <td><?php
                                                if (isset($wpttarProjectResults->dateTime)) : echo esc_html(date('d-m-Y', strtotime($wpttarProjectResults->dateTime)));
                                                endif;
                                                ?></td>

                                            <td><?php
                                                if (isset($wpttarProjectResults->projectStatus) && ($wpttarProjectResults->projectStatus == 'Open' || $wpttarProjectResults->projectStatus == 'Reopen' )) {
                                                    _e('In Progress', 'wpttar');
                                                } else {
                                                    echo esc_html(date('d-m-Y', strtotime($wpttarProjectResults->lastUpdate)));
                                                }
                                                ?></td>
                                            <td><?php
                                                if (isset($getTotalHour['hour'])) : echo esc_html($getTotalHour['hour']);
                                                endif;
                                                ?>&nbsp;
                                                <?php
                                                if (isset($getTotalHour['minutes'])) : echo  esc_html($getTotalHour['minutes']);
                                                endif;
                                                ?></td>

                                            <td>
                                                <?php if(!empty($wpttarProjectHours)) { ?>
                                               <a href="?page=wpttar-project-logs&developerID=<?php echo esc_attr($developerID); ?>&projectID=<?php echo esc_attr($wpttarMembersResult->projectID); ?>" class="blue color"><i class="fa fa-list"></i></a>
                                                <?php }else{ ?>
                                               <a style="color: silver;" title="No project logs available!" class="blue blue"><i class="fa fa-list"></i></a>     
                                               <?php } ?>
                                            </td>

                                            <td>
                                                <?php if(!empty($wpttarProjectHours)) { ?>
                                               <a href="?page=wpttar-developer-projects-comments&developerID=<?php echo esc_attr($developerID); ?>&projectID=<?php echo esc_attr($wpttarMembersResult->projectID); ?>&action='Userpage'" class="blue color"><i class="fa fa-eye"></i></a>
                                                <?php }else{ ?>
                                               <a style="color: silver;" title="No comments available!" class="blue color"><i class="fa fa-eye"></i></a>     
                                               <?php } ?>
                                            </td>
                                        </tr>
                                        <?php
                                        $i++;
                                    }
                                    }
                                }
                                ?>
                            </tbody>
                        </table>                   
                    </div>
                </div>
            </div>
        </div>
    </div><div id="project-model" class="modal fade" tabindex="-1" data-backdrop="static" data-keyboard="false">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="alert alert-success display-hide" id="WPTTARCustomDelete_success"><i class='fa fa-check-square' aria-hidden='true'></i>
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="alert alert-danger display-hide" id="WPTTARCustomDelete_error">
                    <button class="close" data-close="alert"></button>
                </div>
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title"><?php _e('Projects Report', 'wpttar'); ?></h4>
                </div>
                <div class="modal-body" id="info"><?php _e('Please select date range.', 'wpttar'); ?></div>
                <div class="modal-footer">

                    <button type="button" data-dismiss="modal" aria-hidden="true" class="btn default"><i class="fa fa-times"></i><?php _e('Cancel', 'wpttar'); ?></button>
                </div>
            </div>
        </div>
    </div>
    <!-- END PAGE CONTENT-->
    <div class="user-timer-load-in-div"></div>