<?php
global $current_user, $wpdb;
$wpttarTimeZoneSettings = $this->WPTTARGetSettings('wpttarTimeZoneSettingsInfo');
if (isset($wpttarTimeZoneSettings['wpttar-time-zone']) && $wpttarTimeZoneSettings['wpttar-time-zone'] != '') {
    date_default_timezone_set($wpttarTimeZoneSettings['wpttar-time-zone']);
}

$todayDate = esc_sql(date('Y-m-d'));
$wpttarTableDatas = $wpdb->get_row("SELECT * FROM  $this->WpttarProjectsLogTable  WHERE  `updateDate` = '".esc_sql($todayDate)."' AND `endTime` = '00:00:00' AND `developerID` = '".esc_sql($current_user->ID)."'");

$wpttarTodayDateSelect = $this->WPTTARGetTableDataByID($todayDate, $this->WpttarProjectsLogTable, 'updateDate');
if (isset($wpttarTableDatas) && $wpttarTableDatas != '') {
    $wpttarProjectsName = $this->WPTTARGetTableDataByID($wpttarTableDatas->projectID, $this->WpttarProjectsTable, 'id');
}

?>
<!-- START TIMER CONTENT-->

<input type="hidden" id="today-date-select"  value="<?php
if (isset($wpttarTableDatas->updateDate)) : echo esc_attr($wpttarTableDatas->updateDate);
endif;
?>">

<input type="hidden" id="timer-start-Time"  value="<?php
if (isset($wpttarTableDatas->endTime)) : echo esc_attr($wpttarTableDatas->endTime);
endif;
?>">

<input type="hidden" id="user-reload-page-default-time"  value="<?php
if (isset($wpttarTableDatas->startTime)) : echo esc_attr($wpttarTableDatas->startTime);
endif;
?>">

<input type="hidden" id="timer-project-name"  value="<?php
if (isset($wpttarProjectsName->projectName)) : echo esc_attr($wpttarProjectsName->projectName . ':');
endif;
?><?php
if (isset($wpttarProjectsName->id)) : echo esc_attr($wpttarProjectsName->id);
endif;
?>">
<input type="hidden" class="start-to-end-time" id="end-time">
<input type="hidden"  id="developer-id" value="<?php echo $current_user->ID; ?>">
<div class="projectTimer loadhidediv">
    <div class="timerClockHead timerClockStart">
        <div class="timerInner">
            <div class="clockIcon fa fa-clock-o" style="font-size: 20px;"></div>
            <div class="clocktaskTime taskTime"><span class="hours">00</span>:<span class="minutes">00</span>:<span class="seconds">00</span></div>
            <div class="clockTitle clockTitlehide"><?php _e('TIME TRACKING', 'wpttar') ?></div>
            <div class="timerLink directOpenToggle">
                <a class="fa fa-chevron-up"></a>
            </div>
        </div>
    </div>
    <div class="timerClockBody">

        <div class="timerClockSelection dropdown">
            <select class="form-control project-name"  name="wpttar-project-status" style="width: 100%">
                <option  value=""><?php _e('Select Status', 'wpttar') ?></option>
                <?php
                $wpttarMembersResults = $this->WPTTARGetResultsByID($current_user->ID, $this->WpttarTeamsTable, 'teamMember');
                if (!empty($wpttarMembersResults)) {
                    foreach ($wpttarMembersResults as $wpttarMembersResult) {
                        $wpttarProjectResults = $this->WPTTARGetTableDataByID($wpttarMembersResult->projectID, $this->WpttarProjectsTable, 'id');
                        if ($wpttarProjectResults->projectStatus != 'Close') {
                            ?>
                            <option  value="<?php
                            if (isset($wpttarProjectResults->projectName)) : echo esc_html($wpttarProjectResults->projectName . ':');
                            endif;
                            ?><?php
                            if (isset($wpttarProjectResults->id)) : echo esc_attr($wpttarProjectResults->id);
                            endif;
                            ?>">
                                         <?php
                                         if (isset($wpttarProjectResults->projectName)) : echo esc_html($wpttarProjectResults->projectName);
                                         endif;
                                         ?></option>
                            <?php
                        }
                    }
                }
                ?>
            </select>
        </div>

        <div class="taskAction timer-start">
            <a  class="fa fa-play-circle"  onclick="Clock.start()"></a>
        </div>
        <div id="clockdiv" class="taskTime taskTimeStop">
            <span class="hours">00</span>:<span class="minutes">00</span>:<span class="seconds">00</span>
        </div>

        <div class="taskEnd">
            <div class="taskEndText"><?php _e('Are you sure ?', 'wpttar') ?></div>
            <a  class=""  onclick="WPTTARYESDiv()"><?php _e('yes', 'wpttar') ?></a>
            <a  class="" onclick="WPTTARNoDDiv()"><?php _e('no', 'wpttar') ?></a>
        </div>

        <div class="taskNote">
            <form>
                <textarea placeholder="<?php _e('Please Write Some Comment', 'wpttar') ?>" id="timer-comment"></textarea>
                <input type="button" onclick="WPTTARSubmitDiv()" value="submit">
            </form>
        </div>

        <div class="taskAction timer-stop">
            <a  class="fa fa-stop-circle" onclick="stopWork()" style="opacity: 1;"></a>
        </div>
    </div>

</div>
<div class="projectTimer loadmydiv ">
    <div class="timerClockHead timerClockStop">
        <div class="timerInner">
            <div class="clockIcon fa fa-clock-o" style="font-size: 20px;"></div>
            <div class="clockTitle clockTitlehide"><?php _e('time tracking', 'wpttar') ?></div>
            <div class="timerLink">
                <a class="fa fa-chevron-up"></a>
            </div>
        </div>
    </div>
    <div class="timerClockBody">

        <div class="taskDone">
            <div class="taskDoneText"><?php _e('Successfully Submitted.', 'wpttar') ?></div>
            <a onclick="startNewProjects()"><?php _e('start new project', 'wpttar') ?></a>
        </div>
    </div>
</div>

<script type="text/javascript">

    /**   Data base in first time inserted time format of project **/
    var time = "<?php if (isset($wpttarTableDatas->startTime)) : echo esc_attr($wpttarTableDatas->startTime); endif; ?>";
    var convertedTime = (Number(time.split(':')[0]) * 60 + Number(time.split(':')[1])) * 60
    var finalTotal = convertedTime + Number(time.split(':')[2]);
    
    var startTimes = '<?php echo date('H:i:s') ?>';
    var CurrentTime = (Number(startTimes.split(':')[0]) * 60 + Number(startTimes.split(':')[1])) * 60
    var convertedCurrentTime = CurrentTime + Number(startTimes.split(':')[2]);

    /** Divide database time and current time **/
    var appendTimeOnTimer = convertedCurrentTime - finalTotal;
    var timerStartTime = jQuery('#timer-start-Time').val();

    /** Check condition if data base in start time is null or not **/
    if (timerStartTime == '') {
        timerStartTimeUser = 0;
    } else {
        timerStartTimeUser = appendTimeOnTimer;
    }
    var Clock = {
        totalSeconds: parseInt(timerStartTimeUser),
        start: function () {

            var ourprojectName = jQuery('.project-name').val();
            var timerProjectName = jQuery('#timer-project-name').val();
            if (timerProjectName != '') {
                var projectName = timerProjectName;
            } else {
                var projectName = ourprojectName;
            }

            var developerId = jQuery('#developer-id').val();
            var arr = projectName.split(':');
            if (projectName != '') {

                if (timerStartTime == '') {

                    var self = this;
                    function pad(val) {
                        return val > 9 ? val : "0" + val;
                    }
                    this.interval = setInterval(function () {
                        self.totalSeconds += 1;
                        var secs = pad(parseInt(self.totalSeconds % 60));
                        var mins = pad(Math.floor(self.totalSeconds / 60 % 60));
                        var hours = pad(Math.floor((self.totalSeconds / 60) / 60 % 60));

                        jQuery('div.taskTime span.seconds').html(secs);
                        jQuery('div.taskTime span.minutes').html(mins);
                        jQuery('div.taskTime span.hours').html(hours);
                        jQuery('.start-to-end-time').val(hours + ':' + mins + ':' + secs);
                    }, 1000);


                    var startTime = startTimes;
                    jQuery('.taskTimeStop').show();
                    jQuery('.timer-stop').show();
                    jQuery('.timer-start').hide();
                    jQuery('.loadmydiv').hide();
                    jQuery('.taskEnd').hide();
                    jQuery('.timerClockSelection').hide();
                    jQuery('.clockTitlehide').html(arr[0]);

                    var ajax_url = ajaxurl;
                    wpttar_StartTimer_data = {
                        'action': 'WPTTARUserStartTimeLog',
                        'developerId': developerId,
                        'startTime': startTime,
                        'projectId': arr[1],
                    }
                    jQuery.post(ajax_url, wpttar_StartTimer_data, function (response) {

                    });

                } else {

                    var self = this;
                    function pad(val) {
                        return val > 9 ? val : "0" + val;
                    }
                    this.interval = setInterval(function () {
                        self.totalSeconds += 1;
                        var secs = pad(parseInt(self.totalSeconds % 60));
                        var mins = pad(Math.floor(self.totalSeconds / 60 % 60));
                        var hours = pad(Math.floor((self.totalSeconds / 60) / 60 % 60));

                        jQuery('div.taskTime span.seconds').html(secs);
                        jQuery('div.taskTime span.minutes').html(mins);
                        jQuery('div.taskTime span.hours').html(hours);
                        jQuery('.start-to-end-time').val(hours + ':' + mins + ':' + secs);
                    }, 1000);

                    jQuery('.taskTimeStop').show();
                    jQuery('.taskNote').hide();
                    jQuery('.timer-stop').show();
                    jQuery('.timer-start').hide();
                    jQuery('.loadmydiv').hide();
                    jQuery('.taskEnd').hide();
                    jQuery('.timerClockSelection').hide();
                    jQuery('.clockTitlehide').html(arr[0]);
                }
            } else {
                alert('Please select project.')
            }
        },
        pause: function () {
            clearInterval(this.interval);
            delete this.interval;
        },
        resume: function () {
            if (!this.interval)
                this.start();
        }
    };

    jQuery(document).ready(function (e)
    {
        var timerStartTime = jQuery('#timer-start-Time').val();
        var todayDateSelect = jQuery('#today-date-select').val();
        if (timerStartTime == '00:00:00') {
            Clock.start();
        } else {
            jQuery('.taskTimeStop').hide();
            jQuery('.timer-stop').hide();
            jQuery('.taskEnd').hide();
            jQuery('.taskNote').hide();
            jQuery('.loadmydiv').hide();
        }


        if (todayDateSelect == '') {
            jQuery('.loadhidediv').toggleClass('openToggle');
            jQuery('.timerClockBody').slideToggle('slow');
        }

        jQuery('.timerLink').click(function () {
            jQuery('.timerClockBody').slideToggle('slow');
            jQuery('.projectTimer').toggleClass('openToggle');
        });

        jQuery('.timerClockBody li a').click(function () {
            jQuery('.selectedOption').text(jQuery(this).text());
        });
    });

    function stopWork() {
        jQuery('.taskTimeStop').show();
        jQuery('.timer-start').hide();
        jQuery('.timer-stop').hide();
        jQuery('.taskEnd').show();
        jQuery('.taskNote').hide();
        jQuery('.loadmydiv').hide();
    }

    function WPTTARYESDiv() {
        Clock.pause();
        jQuery('#clockdiv').show();
        jQuery('#timer-start').hide();
        jQuery('.timer-stop').hide();
        jQuery('.taskEnd').hide();
        jQuery('.taskNote').show();
        jQuery('#loadmydiv').hide();
    }
    function WPTTARNoDDiv() {
        Clock.resume();
        jQuery('.taskTimeStop').show();
        jQuery('.taskNote').hide();
        jQuery('.timer-stop').show();
        jQuery('.timer-start').hide();
        jQuery('.loadmydiv').hide();
        jQuery('.taskEnd').hide();
        jQuery('.timerClockSelection').hide();
    }
    function startNewProjects() {
        window.location.reload();
    }

    function WPTTARSubmitDiv() {
        jQuery('#timer-start-Time').val("");
        var ourprojectName = jQuery('.project-name').val();
        var timerProjectName = jQuery('#timer-project-name').val();
        if (timerProjectName != '') {
            var projectName = timerProjectName;
        } else {
            var projectName = ourprojectName;
        }
        var developerId = jQuery('#developer-id').val();
        var endtime = jQuery('#end-time').val();
        var timercomment = jQuery('#timer-comment').val();
        var arr = projectName.split(':');
        var ajax_url = ajaxurl;
        wpttar_EndTimer_data = {
            'action': 'WPTTARUserEndTimeLog',
            'developerId': developerId,
            'endtime': endtime,
            'endTimer': '',
            'timercomment': timercomment,
            'projectId': arr[1],
        }
        jQuery.post(ajax_url, wpttar_EndTimer_data, function (response) {
            jQuery('.loadmydiv').show();
            jQuery('.loadmydiv').toggleClass('openToggle');
            jQuery('.loadhidediv').removeClass('projectTimer');
            jQuery('.loadhidediv').hide();
        });
    }
</script>

