<?php

if ( ! function_exists( 'ghostpool_init_variables' ) ) {
	function ghostpool_init_variables() {

		global $socialize;
		$gp_global = get_option( 'socialize' ); 


		/*--------------------------------------------------------------
		1 - WooCommerce Shop Page
		--------------------------------------------------------------*/

		if ( function_exists( 'is_woocommerce' ) && ( is_shop() OR is_product_category() OR is_product_tag() ) ) {

			$gp_post_id = get_option( 'woocommerce_shop_page_id' ); // Get WooCommerce shop page ID	

			$GLOBALS['ghostpool_page_header'] = get_post_meta( $gp_post_id, 'page_page_header', true ) ? get_post_meta( $gp_post_id, 'page_page_header', true ) : $gp_global['shop_page_header'];
			
			$GLOBALS['ghostpool_page_header_bg'] = get_post_meta( $gp_post_id, 'page_page_header_bg', true );
			
			$GLOBALS['ghostpool_page_header_text'] = get_post_meta( $gp_post_id, 'page_page_header', true ) ? get_post_meta( 
			$gp_post_id, 'page_page_header', true ) : $gp_global['shop_page_header_text'];
			
			$GLOBALS['ghostpool_teaser_video_bg'] = get_post_meta( $gp_post_id, 'page_page_header_teaser_video_bg', true );
			
			$GLOBALS['ghostpool_full_video_bg'] = get_post_meta( $gp_post_id, 'page_page_header_full_video_bg', true );		
			
			$GLOBALS['ghostpool_title'] = get_post_meta( $gp_post_id, 'page_title', true );
			
			$GLOBALS['ghostpool_custom_title'] = get_post_meta( $gp_post_id, 'page_custom_title', true );
			
			$GLOBALS['ghostpool_subtitle'] = get_post_meta( $gp_post_id, 'page_subtitle', true );
			
			$GLOBALS['ghostpool_layout'] = get_post_meta( $gp_post_id, 'page_layout', true ) ? get_post_meta( $gp_post_id, 'page_layout', true ) : $gp_global['shop_layout'];
			
			$GLOBALS['ghostpool_left_sidebar'] = get_post_meta( $gp_post_id, 'page_left_sidebar', true ) ? get_post_meta( $gp_post_id, 'page_left_sidebar', true ) : $gp_global['shop_left_sidebar'];
			
			$GLOBALS['ghostpool_right_sidebar'] = get_post_meta( $gp_post_id, 'page_right_sidebar', true ) ? get_post_meta( $gp_post_id, 'page_right_sidebar', true ) : $gp_global['shop_right_sidebar'];
	
		
		/*--------------------------------------------------------------
		2- WooCommerce Products
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'is_woocommerce' ) && is_singular( 'product' ) ) {

			$GLOBALS['ghostpool_page_header'] = 'gp-standard-page-header';
			
			$GLOBALS['ghostpool_title'] = 'enabled';	
			
			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'socialize', get_the_ID(), 'product_layout' ) == 'default' ? 
			$gp_global['product_layout'] : redux_post_meta( 'socialize', get_the_ID(), 'product_layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'product_left_sidebar' ) == '' ? 
			$gp_global['product_left_sidebar'] : redux_post_meta( 'socialize', get_the_ID(), 'product_left_sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'product_right_sidebar' ) == '' ? 
			$gp_global['product_right_sidebar'] : redux_post_meta( 'socialize', get_the_ID(), 'product_right_sidebar' );
	

		/*--------------------------------------------------------------
		3 - BuddyPress
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'bp_is_active' ) && ! bp_is_blog_page() ) {

			$bp_pages = get_option( 'bp-pages' );

			if ( bp_is_activity_component() ) {
				$gp_page_id = $bp_pages['activity'];
			} elseif ( bp_is_groups_component() ) {
				$gp_page_id = $bp_pages['groups'];
			} elseif ( bp_is_members_component() ) {
				$gp_page_id = $bp_pages['members'];
			} else {
				$gp_page_id = null;
			}
			
			$GLOBALS['ghostpool_page_header'] = get_post_meta( $gp_page_id, 'page_page_header', true ) ? get_post_meta( $gp_page_id, 'page_page_header', true ) : $gp_global['bp_page_header'];

			$gp_page_header_bg = redux_post_meta( 'socialize', $gp_page_id, 'page_page_header_bg' );
			$GLOBALS['ghostpool_page_header_bg'] = ! empty( $gp_page_header_bg['url'] ) ? $gp_page_header_bg : $gp_global['bp_page_header_bg'];
							
			$GLOBALS['ghostpool_page_header_text'] = get_post_meta( $gp_page_id, 'page_page_header_text', true ) ? get_post_meta( $gp_page_id, 'page_page_header_text', true ) : $gp_global['bp_page_header_text'];
			
			$GLOBALS['ghostpool_layout'] = get_post_meta( $gp_page_id, 'page_layout', true ) ? get_post_meta( $gp_page_id, 'page_layout', true ) : $gp_global['bp_layout'];
			
			$GLOBALS['ghostpool_left_sidebar'] = get_post_meta( $gp_page_id, 'page_left_sidebar', true ) ? get_post_meta( $gp_page_id, 'page_left_sidebar', true ) : $gp_global['bp_left_sidebar'];
			
			$GLOBALS['ghostpool_right_sidebar'] = get_post_meta( $gp_page_id, 'page_right_sidebar', true ) ? get_post_meta( $gp_page_id, 'page_right_sidebar', true ) : $gp_global['bp_right_sidebar'];
			

		/*--------------------------------------------------------------
		4 - bbPress
		--------------------------------------------------------------*/

		} elseif ( function_exists( 'is_bbpress' ) && is_bbpress() ) {

			if ( bbp_is_single_topic() OR bbp_is_single_reply() ) {
				$gp_forum_id = bbp_get_topic_forum_id();
			} else {
				$gp_forum_id = get_the_ID();
			}

			if ( bbp_is_single_forum() OR bbp_is_single_topic() OR bbp_is_single_reply() ) {

				$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'socialize', $gp_forum_id, 'bbpress_page_header' ) == 'default' ? 
				$gp_global['bbpress_page_header'] : redux_post_meta( 'socialize', $gp_forum_id, 'bbpress_page_header' );

				$gp_page_header_bg = redux_post_meta( 'socialize', $gp_forum_id, 'bbpress_page_header_bg' );
				$GLOBALS['ghostpool_page_header_bg'] = ! empty( $gp_page_header_bg['url'] ) ? $gp_page_header_bg : $gp_global['bbpress_page_header_bg'];
							
				$GLOBALS['ghostpool_page_header_text'] = redux_post_meta( 'socialize', $gp_forum_id, 'bbpress_page_header_text' ) == '' ? $gp_global['bbpress_page_header_text'] : redux_post_meta( 'socialize', $gp_forum_id, 'bbpress_page_header_text' );
								
				$GLOBALS['ghostpool_layout'] = redux_post_meta( 'socialize', $gp_forum_id, 'bbpress_layout' ) == 'default' ? $gp_global['bbpress_layout'] : redux_post_meta( 'socialize', $gp_forum_id, 'bbpress_layout' );
				
				$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'socialize', $gp_forum_id, 'bbpress_left_sidebar' ) == '' ? $gp_global['bbpress_left_sidebar'] : redux_post_meta( 'socialize', $gp_forum_id, 'bbpress_left_sidebar' );	
				
				$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'socialize', $gp_forum_id, 'bbpress_right_sidebar' ) == '' ? $gp_global['bbpress_right_sidebar'] : redux_post_meta( 'socialize', $gp_forum_id, 'bbpress_right_sidebar' );			
			
			} else {
							
				$GLOBALS['ghostpool_page_header'] = $gp_global['bbpress_page_header'];
				
				$GLOBALS['ghostpool_page_header_bg'] = $gp_global['bbpress_page_header_bg'];
				
				$GLOBALS['ghostpool_page_header_text'] = $gp_global['bbpress_page_header_text'];
				
				$GLOBALS['ghostpool_layout'] = $gp_global['bbpress_layout'];
				
				$GLOBALS['ghostpool_left_sidebar'] = $gp_global['bbpress_left_sidebar'];
				
				$GLOBALS['ghostpool_right_sidebar'] = $gp_global['bbpress_right_sidebar'];
			
			}


		/*--------------------------------------------------------------
		5 - Events Calendar
		--------------------------------------------------------------*/

		} elseif ( class_exists( 'Tribe__Events__Main' ) && is_post_type_archive( 'tribe_events' ) ) {

			$GLOBALS['ghostpool_page_header'] = $gp_global['events_page_header'];		
			
			$GLOBALS['ghostpool_page_header_bg'] = $gp_global['events_page_header_bg'];		
			
			$GLOBALS['ghostpool_page_header_text'] = $gp_global['events_page_header_text'];
			
			$GLOBALS['ghostpool_title'] = 'disabled';
			
			$GLOBALS['ghostpool_layout'] = $gp_global['events_layout'];
			
			$GLOBALS['ghostpool_left_sidebar'] = $gp_global['events_left_sidebar'];	
			
			$GLOBALS['ghostpool_right_sidebar'] = $gp_global['events_right_sidebar'];			


		/*--------------------------------------------------------------
		6 - Events Posts
		--------------------------------------------------------------*/

		} elseif ( class_exists( 'Tribe__Events__Main' ) && is_singular( 'tribe_events' ) ) {

			$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'socialize', get_the_ID(), 'events_post_page_header' ) == 'default' ? $gp_global['events_post_page_header'] : redux_post_meta( 'socialize', get_the_ID(), 'events_post_page_header' );

			$gp_page_header_bg = redux_post_meta( 'socialize', get_the_ID(), 'events_post_page_header_bg' );
			$GLOBALS['ghostpool_page_header_bg'] = ! empty( $gp_page_header_bg['url'] ) ? $gp_page_header_bg : $gp_global['events_post_page_header_bg'];
									
			$GLOBALS['ghostpool_page_header_text'] = redux_post_meta( 'socialize', get_the_ID(), 'events_post_page_header_text' ) == '' ? $gp_global['events_post_page_header_text'] : redux_post_meta( 'socialize', get_the_ID(), 'events_post_page_header_text' );
			
			$GLOBALS['ghostpool_title'] = 'disabled';
			
			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'socialize', get_the_ID(), 'events_post_layout' ) == 'default' ? $gp_global['events_post_layout'] : redux_post_meta( 'socialize', get_the_ID(), 'events_post_layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'events_post_left_sidebar' ) == '' ? $gp_global['events_post_left_sidebar'] : redux_post_meta( 'socialize', get_the_ID(), 'events_post_left_sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'events_post_right_sidebar' ) == '' ? $gp_global['events_post_right_sidebar'] : redux_post_meta( 'socialize', get_the_ID(), 'events_post_right_sidebar' );
			

		/*--------------------------------------------------------------
		7 - Portfolio Categories
		--------------------------------------------------------------*/

		} elseif ( is_post_type_archive( 'gp_portfolio_item' ) OR is_tax( 'gp_portfolios' ) )  {

			// Get category option
			$gp_term_data = null;
			if ( isset( get_queried_object()->term_id ) ) {
				$gp_term_id = get_queried_object()->term_id;
				$gp_term_data = get_option( "taxonomy_$gp_term_id" );
			}	
			
			$GLOBALS['ghostpool_page_header'] = ! isset( $gp_term_data['page_header'] ) || $gp_term_data['page_header'] == 'default' ? $gp_global['portfolio_cat_page_header'] : $gp_term_data['page_header'];
			
			$GLOBALS['ghostpool_page_header_bg'] = $gp_term_data['bg_image'];
			
			$GLOBALS['ghostpool_page_header_text'] =  $gp_global['portfolio_cat_page_header_text'];
						
			$GLOBALS['ghostpool_title'] = 'enabled';	
			
			$GLOBALS['ghostpool_layout'] = ! isset( $gp_term_data['layout'] ) || $gp_term_data['layout'] == 'default' ? $gp_global['portfolio_cat_layout'] : $gp_term_data['layout'];
			
			$GLOBALS['ghostpool_left_sidebar'] = ! isset( $gp_term_data['left_sidebar'] ) || $gp_term_data['left_sidebar'] == 'default' ? $gp_global['portfolio_cat_left_sidebar'] : $gp_term_data['left_sidebar']; 
						
			$GLOBALS['ghostpool_right_sidebar'] = ! isset( $gp_term_data['right_sidebar'] ) || $gp_term_data['right_sidebar'] == 'default' ? $gp_global['portfolio_cat_right_sidebar'] : $gp_term_data['right_sidebar'];


		/*--------------------------------------------------------------
		8 - Portfolio Page Template
		--------------------------------------------------------------*/

		} elseif ( is_page_template( 'portfolio-template.php' ) )  {

			$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_page_header' ) == 'default' ? $gp_global['portfolio_template_page_header'] : redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_page_header' );

			$GLOBALS['ghostpool_page_header_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_page_header_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_page_header_bg' ) : '';

			$GLOBALS['ghostpool_page_header_text'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_page_header_text' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_page_header_text' ) : '';			
						
			$GLOBALS['ghostpool_teaser_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_page_header_teaser_video_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_page_header_teaser_video_bg' ) : '';
			
			$GLOBALS['ghostpool_full_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_page_header_full_video_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_page_header_full_video_bg' ) : '';
				
			$GLOBALS['ghostpool_title'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_title' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_title' ) : '';	
		
			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_layout' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_layout' ) : '';
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_left_sidebar' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_left_sidebar' ) : '';
			
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_right_sidebar' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_template_right_sidebar' ) : '';

		
		/*--------------------------------------------------------------
		9 - Portfolio Items
		--------------------------------------------------------------*/

		} elseif ( is_singular( 'gp_portfolio_item' ) ) {

			$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_page_header' ) == 'default' ? $gp_global['portfolio_item_page_header'] : redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_page_header' );

			$GLOBALS['ghostpool_page_header_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_page_header_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_page_header_bg' ) : '';	
		
			$GLOBALS['ghostpool_page_header_text'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_page_header_text' ) == '' ? $gp_global['portfolio_item_page_header_text'] : redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_page_header_text' );
			
			$GLOBALS['ghostpool_teaser_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_page_header_teaser_video_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_page_header_teaser_video_bg' ) : '';
			
			$GLOBALS['ghostpool_full_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_page_header_full_video_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_page_header_full_video_bg' ) : '';
					
			$GLOBALS['ghostpool_title'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_title' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_title' ) : '';	
			
			$GLOBALS['ghostpool_custom_title'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_custom_title' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_custom_title' ) : '';
			
			$GLOBALS['ghostpool_subtitle'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_subtitle' ) ? redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_subtitle' ) : '';
			
			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_layout' ) == 'default' ? $gp_global['portfolio_item_layout'] : redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_left_sidebar' ) == '' ? $gp_global['portfolio_item_left_sidebar'] : redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_left_sidebar' );	
			
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_right_sidebar' ) == '' ? $gp_global['portfolio_item_right_sidebar'] : redux_post_meta( 'socialize', get_the_ID(), 'portfolio_item_right_sidebar' );	


		/*--------------------------------------------------------------
		10 - Search/Author Results
		--------------------------------------------------------------*/

		} elseif ( is_search() or is_author() ) {
			
			$GLOBALS['ghostpool_page_header'] = $gp_global['search_page_header'];
			
			$GLOBALS['ghostpool_page_header_bg'] = $gp_global['search_page_header_bg'];

			$GLOBALS['ghostpool_page_header_text'] = $gp_global['search_page_header_text'];	
									
			$GLOBALS['ghostpool_layout'] = $gp_global['search_layout'];
			
			$GLOBALS['ghostpool_left_sidebar'] = $gp_global['search_left_sidebar']; 
			
			$GLOBALS['ghostpool_right_sidebar'] = $gp_global['search_right_sidebar'];
	
	
		/*--------------------------------------------------------------
		11 - Blog Page Template
		--------------------------------------------------------------*/

		} elseif ( is_page_template( 'blog-template.php' ) )  {

			$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_page_header' ) ? redux_post_meta( 'socialize', get_the_ID(), 'blog_template_page_header' ) : '';
			
			$GLOBALS['ghostpool_page_header_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_page_header_bg' ) ?  redux_post_meta( 'socialize', get_the_ID(), 'blog_template_page_header_bg' ) : '';
			
			$GLOBALS['ghostpool_page_header_text'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_page_header_text' ) ? redux_post_meta( 'socialize', get_the_ID(), 'blog_template_page_header_text' ) : '';
				
			$GLOBALS['ghostpool_teaser_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_page_header_teaser_video_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'blog_template_page_header_teaser_video_bg' ) : '';				
			
			$GLOBALS['ghostpool_full_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_page_header_full_video_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'blog_template_page_header_full_video_bg' ) : '';
				
			$GLOBALS['ghostpool_title'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_title' ) ? redux_post_meta( 'socialize', get_the_ID(), 'blog_template_title' ) : '';
			
			$GLOBALS['ghostpool_custom_title'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_custom_title' ) ? redux_post_meta( 'socialize', get_the_ID(), 'blog_template_custom_title' ) : '';
			
			$GLOBALS['ghostpool_subtitle'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_subtitle' ) ? redux_post_meta( 'socialize', get_the_ID(), 'blog_template_subtitle' ) : '';
		
			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_layout' ) ? redux_post_meta( 'socialize', get_the_ID(), 'blog_template_layout' ) : '';
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_left_sidebar' ) ? redux_post_meta( 'socialize', get_the_ID(), 'blog_template_left_sidebar' ) : '';	
						
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_right_sidebar' ) ? redux_post_meta( 'socialize', get_the_ID(), 'blog_template_right_sidebar' ) : '';	


		/*--------------------------------------------------------------
		12 - Homepage Template
		--------------------------------------------------------------*/

		} elseif ( is_page_template( 'homepage-template.php' ) )  {
				
			$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'socialize', get_the_ID(), 'blog_template_page_header' ) == 'default' ? $gp_global['homepage_page_header'] : redux_post_meta( 'socialize', get_the_ID(), 'homepage_page_header' );
			
			$GLOBALS['ghostpool_page_header_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'homepage_page_header_bg' ) ?  redux_post_meta( 'socialize', get_the_ID(), 'homepage_page_header_bg' ) : '';
			
			$GLOBALS['ghostpool_page_header_text'] = redux_post_meta( 'socialize', get_the_ID(), 'homepage_page_header_text' ) ? redux_post_meta( 'socialize', get_the_ID(), 'homepage_page_header_text' ) : '';
				
			$GLOBALS['ghostpool_teaser_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'homepage_page_header_teaser_video_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'homepage_page_header_teaser_video_bg' ) : '';				
			
			$GLOBALS['ghostpool_full_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'homepage_page_header_full_video_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'homepage_page_header_full_video_bg' ) : '';
				
			$GLOBALS['ghostpool_title'] = redux_post_meta( 'socialize', get_the_ID(), 'homepage_title' ) ? redux_post_meta( 'socialize', get_the_ID(), 'homepage_title' ) : '';
			
			$GLOBALS['ghostpool_custom_title'] = redux_post_meta( 'socialize', get_the_ID(), 'homepage_custom_title' ) ? redux_post_meta( 'socialize', get_the_ID(), 'homepage_custom_title' ) : '';
			
			$GLOBALS['ghostpool_subtitle'] = redux_post_meta( 'socialize', get_the_ID(), 'homepage_subtitle' ) ? redux_post_meta( 'socialize', get_the_ID(), 'homepage_subtitle' ) : '';
		
			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'socialize', get_the_ID(), 'homepage_layout' ) ? redux_post_meta( 'socialize', get_the_ID(), 'homepage_layout' ) : '';
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'homepage_left_sidebar' ) ? redux_post_meta( 'socialize', get_the_ID(), 'homepage_left_sidebar' ) : '';	
						
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'homepage_right_sidebar' ) ? redux_post_meta( 'socialize', get_the_ID(), 'homepage_right_sidebar' ) : '';


		/*--------------------------------------------------------------
		13 - Blank page
		--------------------------------------------------------------*/

		} elseif ( is_page_template( 'blank-page-template.php' ) ) {

			$GLOBALS['ghostpool_page_header'] = apply_filters( 'gp_blank_page_header', 'gp-standard-page-header' );
			
			$GLOBALS['ghostpool_layout'] = apply_filters( 'gp_blank_layout', 'gp-no-sidebar' );
	
			$GLOBALS['ghostpool_left_sidebar'] = apply_filters( 'gp_blank_left_sidebar', 'gp-left-sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = apply_filters( 'gp_blank_right_sidebar', 'gp-right-sidebar' );
			

		/*--------------------------------------------------------------
		14 - Attachment page
		--------------------------------------------------------------*/

		} elseif ( is_attachment() ) {

			$GLOBALS['ghostpool_page_header'] = apply_filters( 'gp_attachment_page_header', 'gp-standard-page-header' );
			
			$GLOBALS['ghostpool_layout'] = apply_filters( 'gp_attachment_layout', 'gp-no-sidebar' );
	
			$GLOBALS['ghostpool_left_sidebar'] = apply_filters( 'gp_attachment_left_sidebar', 'gp-left-sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = apply_filters( 'gp_attachment_right_sidebar', 'gp-right-sidebar' );
			
												
		/*--------------------------------------------------------------
		15 - Error 404 page
		--------------------------------------------------------------*/

		} elseif ( is_404() ) {

			$GLOBALS['ghostpool_page_header'] = apply_filters( 'gp_error_page_header', 'gp-standard-page-header' );
			
			$GLOBALS['ghostpool_layout'] = apply_filters( 'gp_error_layout', 'gp-no-sidebar' );
	
			$GLOBALS['ghostpool_left_sidebar'] = apply_filters( 'gp_error_left_sidebar', 'gp-left-sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = apply_filters( 'gp_error_right_sidebar', 'gp-right-sidebar' );
			
								
		/*--------------------------------------------------------------
		16 - Post Categories, Archives & Tags
		--------------------------------------------------------------*/

		} elseif ( is_home() OR is_archive() ) {

			// Get category option
			$gp_term_data = null;
			if ( isset( get_queried_object()->term_id ) ) {
				$gp_term_id = get_queried_object()->term_id;
				$gp_term_data = get_option( "taxonomy_$gp_term_id" );
			}
			
			$GLOBALS['ghostpool_page_header'] = ! isset( $gp_term_data['page_header'] ) || $gp_term_data['page_header'] == 'default' ? $gp_global['cat_page_header'] : $gp_term_data['page_header'];

			$GLOBALS['ghostpool_page_header_bg'] = $gp_term_data['bg_image'];
		
			$GLOBALS['ghostpool_page_header_text'] = $gp_global['cat_page_header_text'];
			
			$GLOBALS['ghostpool_layout'] = ! isset( $gp_term_data['layout'] ) || $gp_term_data['layout'] == 'default' ? $gp_global['cat_layout'] : $gp_term_data['layout'];
			
			$GLOBALS['ghostpool_left_sidebar'] = ! isset( $gp_term_data['left_sidebar'] ) || $gp_term_data['left_sidebar'] == 'default' ? $gp_global['cat_left_sidebar'] : $gp_term_data['left_sidebar']; 
						
			$GLOBALS['ghostpool_right_sidebar'] = ! isset( $gp_term_data['right_sidebar'] ) || $gp_term_data['right_sidebar'] == 'default' ? $gp_global['cat_right_sidebar'] : $gp_term_data['right_sidebar'];
			

		/*--------------------------------------------------------------
		17 - Posts
		--------------------------------------------------------------*/

		} elseif ( is_singular( 'post' ) ) {
	
			$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'socialize', get_the_ID(), 'post_page_header' ) == 'default' ? $gp_global['post_page_header'] : redux_post_meta( 'socialize', get_the_ID(), 'post_page_header' );
						
			$GLOBALS['ghostpool_page_header_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'post_page_header_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'post_page_header_bg' ) : '';
			
			$GLOBALS['ghostpool_page_header_text'] = redux_post_meta( 'socialize', get_the_ID(), 'post_page_header_text' ) == '' ? $gp_global['post_page_header_text'] : redux_post_meta( 'socialize', get_the_ID(), 'post_page_header_text' );
					
			$GLOBALS['ghostpool_teaser_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'post_page_header_teaser_video_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'post_page_header_teaser_video_bg' ) : '';
			
			$GLOBALS['ghostpool_full_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'post_page_header_full_video_bg' ) ? redux_post_meta( 'socialize', get_the_ID(), 'post_page_header_full_video_bg' ) : '';
			
			$GLOBALS['ghostpool_title'] = redux_post_meta( 'socialize', get_the_ID(), 'post_title' ) ? redux_post_meta( 'socialize', get_the_ID(), 'post_title' ) : '';
			
			$GLOBALS['ghostpool_custom_title'] = redux_post_meta( 'socialize', get_the_ID(), 'post_custom_title' ) ? redux_post_meta( 'socialize', get_the_ID(), 'post_custom_title' ) : '';
			
			$GLOBALS['ghostpool_subtitle'] = redux_post_meta( 'socialize', get_the_ID(), 'post_subtitle' ) ? redux_post_meta( 'socialize', get_the_ID(), 'post_subtitle' ) : '';
			
			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'socialize', get_the_ID(), 'post_layout' ) == 'default' ? $gp_global['post_layout'] : redux_post_meta( 'socialize', get_the_ID(), 'post_layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'post_left_sidebar' ) == '' ? $gp_global['post_left_sidebar'] : redux_post_meta( 'socialize', get_the_ID(), 'post_left_sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'post_right_sidebar' ) == '' ? $gp_global['post_right_sidebar'] : redux_post_meta( 'socialize', get_the_ID(), 'post_right_sidebar' );


		/*--------------------------------------------------------------
		18 - Slides
		--------------------------------------------------------------*/

		} elseif ( is_singular( 'gp_slide' ) ) {

			$GLOBALS['ghostpool_page_header'] = apply_filters( 'gp_slides_page_header', 'gp-standard-page-header' );
			
			$GLOBALS['ghostpool_title'] = apply_filters( 'gp_slides_title', '' );
			
			$GLOBALS['ghostpool_layout'] = apply_filters( 'gp_slides_layout', 'gp-no-sidebar' );
	
			$GLOBALS['ghostpool_left_sidebar'] = apply_filters( 'gp_slides_left_sidebar', 'gp-left-sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = apply_filters( 'gp_slides_right_sidebar', 'gp-right-sidebar' );
	
	
		/*--------------------------------------------------------------
		19 - Pages
		--------------------------------------------------------------*/

		} elseif ( is_page() ) {

			$GLOBALS['ghostpool_page_header'] = redux_post_meta( 'socialize', get_the_ID(), 'page_page_header' ) == 'default' ? $gp_global['page_page_header'] : redux_post_meta( 'socialize', get_the_ID(), 'page_page_header' );
			
			$GLOBALS['ghostpool_page_header_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'page_page_header_bg' );
						
			$GLOBALS['ghostpool_page_header_text'] = redux_post_meta( 'socialize', get_the_ID(), 'page_page_header_text' ) == '' ? $gp_global['page_page_header_text'] : redux_post_meta( 'socialize', get_the_ID(), 'page_page_header_text' );

			$GLOBALS['ghostpool_teaser_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'page_page_header_teaser_video_bg' );
			
			$GLOBALS['ghostpool_full_video_bg'] = redux_post_meta( 'socialize', get_the_ID(), 'page_page_header_full_video_bg' );		
			
			$GLOBALS['ghostpool_title'] = redux_post_meta( 'socialize', get_the_ID(), 'page_title' );
			
			$GLOBALS['ghostpool_custom_title'] = redux_post_meta( 'socialize', get_the_ID(), 'page_custom_title' );
			
			$GLOBALS['ghostpool_subtitle'] = redux_post_meta( 'socialize', get_the_ID(), 'page_subtitle' );
			
			$GLOBALS['ghostpool_layout'] = redux_post_meta( 'socialize', get_the_ID(), 'page_layout' ) == 'default' ? 
			$gp_global['page_layout'] : redux_post_meta( 'socialize', get_the_ID(), 'page_layout' );
			
			$GLOBALS['ghostpool_left_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'page_left_sidebar' ) == '' ? $gp_global['page_left_sidebar'] : 
			redux_post_meta( 'socialize', get_the_ID(), 'page_left_sidebar' );	
					
			$GLOBALS['ghostpool_right_sidebar'] = redux_post_meta( 'socialize', get_the_ID(), 'page_right_sidebar' ) == '' ? $gp_global['page_right_sidebar'] : 
			redux_post_meta( 'socialize', get_the_ID(), 'page_right_sidebar' );
						
			$GLOBALS['ghostpool_featured_image'] = redux_post_meta( 'socialize', get_the_ID(), 'page_featured_image' ) == 'default' ? 
			$gp_global['page_featured_image'] : redux_post_meta( 'socialize', get_the_ID(), 'page_featured_image' );
			
			$gp_image = redux_post_meta( 'socialize', get_the_ID(), 'page_image' );
			
			$GLOBALS['ghostpool_image_width'] = ! empty( $gp_image['width'] ) ? $gp_image['width'] : $gp_global['page_image']['width'];
			
			$GLOBALS['ghostpool_image_height'] = ! empty( $gp_image['height'] ) ? $gp_image['height'] : 
			$gp_global['page_image']['height'];
			
			$GLOBALS['ghostpool_hard_crop'] = redux_post_meta( 'socialize', get_the_ID(), 'page_hard_crop' ) == 'default' ? 
			$gp_global['page_hard_crop'] : redux_post_meta( 'socialize', get_the_ID(), 'page_hard_crop' );
			
			$GLOBALS['ghostpool_image_alignment'] = redux_post_meta( 'socialize', get_the_ID(), 'page_image_alignment' ) == 'default' ? $gp_global['page_image_alignment'] : redux_post_meta( 'socialize', get_the_ID(), 'page_image_alignment' );


		/*--------------------------------------------------------------
		20 - Custom Post Types
		--------------------------------------------------------------*/

		} else {

			$GLOBALS['ghostpool_page_header'] = apply_filters( 'gp_cpt_page_header', 'gp-standard-page-header' );
			
			$GLOBALS['ghostpool_title'] =  apply_filters( 'gp_cpt_title', 'enabled' );
			
			$GLOBALS['ghostpool_layout'] =  apply_filters( 'gp_cpt_layout', 'gp-no-sidebar' );
	
			$GLOBALS['ghostpool_left_sidebar'] = apply_filters( 'gp_cpt_left_sidebar', 'gp-left-sidebar' );
			
			$GLOBALS['ghostpool_right_sidebar'] = apply_filters( 'gp_cpt_right_sidebar', 'gp-right-sidebar' );

		}


		/*--------------------------------------------------------------
		Add init variables via your child theme using this function
		--------------------------------------------------------------*/
		
		if ( function_exists( 'ghostpool_custom_init_variables' ) ) {
			ghostpool_custom_init_variables();
		}
		
	}
}

?>