<?php

/**************************************
WIDGET: sport_toggle
***************************************/

	add_action('widgets_init', 'register_widget_sport_toggle' );
	function register_widget_sport_toggle () {
		register_widget('sport_toggle');	
	}

	class sport_toggle extends WP_Widget {

		/**************************************
		1. INIT
		***************************************/
		function __construct () {

				$widget_ops = array(
					'classname' => 'sport_toggle', 								
					'description' => __('Displays a toggle', "loc_sport_widgets_plugin")	 				
				);
				$control_ops = array(
					'width' => 300, 
					'height' => 350, 
					'id_base' => 'sport_toggle' 														
				);

				$this->WP_Widget('sport_toggle', __('Sport: Toggle', "loc_sport_widgets_plugin"), $widget_ops, $control_ops );	
		}

		/**************************************
		2. UPDATE
		***************************************/
		function update($new_instance, $old_instance) {
			return $new_instance;	 
		}

		/**************************************
		3. FORM
		***************************************/
		function form($instance) {

			//default for checkboxes
			if (empty($instance)) {
				$defaults_checkboxes = array(
					// 'fb_faces' => 'checked'
				);	
			}

			//defaults
			$defaults = array( 
				'widget_title' 	=> __('Toggle', "loc_sport_widgets_plugin"),
				'toggle'		=> array(
					0				=> array(
						'title'			=> "Toggle Trigger",
						'content'		=> "",
					),
				),
			);

			//merge default
			if (!empty($defaults_checkboxes)) $defaults = array_merge($defaults, $defaults_checkboxes);

			$instance = wp_parse_args($instance, $defaults);
			extract($instance);

			?>

				<p>
					<label for="<?php echo $this->get_field_id('widget_title'); ?> "><?php _e("Title", "loc_sport_widgets_plugin"); ?>: </label><br>
					<input type='text' id='<?php echo $this->get_field_id('widget_title'); ?>' name='<?php echo $this->get_field_name('widget_title'); ?>' value="<?php if(isset($widget_title)) echo htmlspecialchars($widget_title); ?>">
				</p>

				<br>

				<?php _e("toggle sections", "loc_sport_widgets_plugin"); ?>:
				
				<ul class="widget_sortable" data-split_index="3">
				<?php
					for ($i = 0; $i < count($toggle); $i++) {  
					?>

						<li>
							<input class="widefat li_option" type='text' name='<?php echo $this->get_field_name('toggle')."[".$i."][title]"; ?>' value="<?php if(isset($toggle[$i]['title'])) echo htmlspecialchars($toggle[$i]['title']); ?>">
							<textarea class='widefat li_option' name='<?php echo $this->get_field_name('toggle')."[".$i."][content]"; ?>' rows='5'><?php if (isset($toggle[$i]['content'])) echo $toggle[$i]['content']; ?></textarea>
						</li>
					<?php
					}
				?>

				</ul>

				<div class="ul_control" data-min="1" data-max="1000">
					<input type="button" class="button ul_add" value="<?php _e("Add", "loc_sport_widgets_plugin"); ?>" />
					<input type="button" class="button ul_del" value="<?php _e("Delete", "loc_sport_widgets_plugin"); ?>" />
				</div>



			<?php

		}

		/**************************************
		4. DISPLAY
		***************************************/
		function widget($args, $instance) {
			extract($args);								
			extract($instance);							
           
			// DEFAULTS
			if (empty($instance)) {
				$widget_title 		= __('Toggle', "loc_sport_widgets_plugin");
				$toggle				= array(
					0					=> array(
						'title'				=> "Toggle Trigger",
						'content'			=> "",
					),
				);
			}

            // WPML
            if (function_exists('icl_translate')) { $widget_title = icl_translate('loc_sport_widgets_plugin', "$widget_id-widget[widget_title]", $widget_title); }
			
			?>

			<?php echo $before_widget; ?>

			<?php echo $before_title . $widget_title . $after_title; ?>

    			<ul class="toggle">

    				<?php
    					
    					for ($i = 0; $i < count($toggle); $i++) {  

				            // WPML
				            if (function_exists('icl_translate')) { $toggle[$i]['title'] = icl_translate('loc_sport_widgets_plugin', "$widget_id-widget[$i][title]", $toggle[$i]['title']); }
				            if (function_exists('icl_translate')) { $toggle[$i]['content'] = icl_translate('loc_sport_widgets_plugin', "$widget_id-widget[$i][content]", $toggle[$i]['content']); }
    					
    					?>
		    			    <li>
		    			      <a href='#' class='toggle-btn<?php if ($i === 0) { echo " active"; } ?>'><?php echo $toggle[$i]['title']; ?></a>
		    			      <div class='toggle-content<?php if ($i === 0) { echo " active"; } ?>'>
		    			      	<p><?php echo $toggle[$i]['content']; ?></p>
		    			      </div>
		    			    </li>
    					<?php
    					}
    				
    				?>

    			  </ul>

			<?php echo $after_widget; ?>


			<?php
		}

	} //END CLASS



