<?php
/**
 * Register new options.
 *
 * @package     wpum-user-verification
 * @copyright   Copyright (c) 2016, Alessandro Tesoro
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since       1.0.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Inject addon settings into settings panel.
 *
 * @since 1.0.0
 * @param  array $settings original settings.
 * @return array           new settings.
 */
function wpumuv_settings( $settings ) {

	$new_settings = array(
		array(
			'id'      => 'wpumuv_settings',
			'name'    => '<strong>' . esc_html__( 'User Verification Settings', 'wpum-user-verification' ) . '</strong>',
			'type'    => 'header',
		),
		array(
			'id'      => 'user_verification_method',
			'name'    => esc_html__( 'Verification method', 'wpum-user-verification' ),
			'desc'    => esc_html__( 'Select which method to use to approve users on this site.', 'wpum-user-verification' ),
			'type'    => 'radio',
			'options' => array(
				'email'  => esc_html__( 'Email verification.', 'wpum-user-verification' ),
				'manual' => esc_html__( 'Manual approval.', 'wpum-user-verification' ),
			)
		),
		array(
			'id'      => 'user_verification_removal',
			'name'    => esc_html__( 'Automatically remove users', 'wpum-user-verification' ),
			'desc'    => esc_html__( 'Remove users who haven\'t verified their account within 30 days. Works only when email verification is enabled.', 'wpum-user-verification' ),
			'type'    => 'checkbox',
		),
	);

	return array_merge( $settings, $new_settings );

}
add_filter( 'wpum_settings_extensions', 'wpumuv_settings', 1 );
