<?php
/**
 * The template for displaying comments
 *
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
use Arkfield\Misc\Service;

if ( post_password_required() ) {
	return;
}
?>

<!-- Comments -->
<section class="comments">
	<?php if ( have_comments() ) : ?>
		<h2><?php comments_number(
				esc_html__( 'Comments', 'arkfield' ),
				esc_html__( 'Comments', 'arkfield' ),
				esc_html__( 'Comments', 'arkfield' )
			); ?>
		</h2>

		<ul class="comment-list">
			<?php wp_list_comments( array(
				'short_ping' => true,
				'type'       => 'comment',
				'walker'     => Service::custom_walker_comment(),
			) ); ?>
		</ul>

		<?php Service::utils()->get_partial( 'post/comments-navigation' ); ?>

	<?php endif; ?>

	<?php
	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
		?>
		<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'arkfield' ); ?></p>
	<?php endif; ?>

	<?php Service::utils()->get_partial( 'post/comment-form' ); ?>

</section>