<?php
namespace Arkfield\Misc;

use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Container;
use Symfony\Component\DependencyInjection\Exception\InactiveScopeException;
use Symfony\Component\DependencyInjection\Exception\InvalidArgumentException;
use Symfony\Component\DependencyInjection\Exception\LogicException;
use Symfony\Component\DependencyInjection\Exception\RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\FrozenParameterBag;

/**
 * Application_Service_Container.
 *
 * This class has been auto-generated
 * by the Symfony Dependency Injection Component.
 */
class Application_Service_Container extends Container
{
    private $parameters;
    private $targetDirs = array();

    /**
     * Constructor.
     */
    public function __construct()
    {
        $this->services =
        $this->scopedServices =
        $this->scopeStacks = array();
        $this->scopes = array();
        $this->scopeChildren = array();
        $this->methodMap = array(
            'back_compat' => 'getBackCompatService',
            'blog_config' => 'getBlogConfigService',
            'blog_dal' => 'getBlogDalService',
            'blog_manager' => 'getBlogManagerService',
            'blog_utils' => 'getBlogUtilsService',
            'bootstrap' => 'getBootstrapService',
            'custom_walker_comment' => 'getCustomWalkerCommentService',
            'google_fonts_options' => 'getGoogleFontsOptionsService',
            'mce_manager' => 'getMceManagerService',
            'meta_box_dal' => 'getMetaBoxDalService',
            'meta_box_field_generator' => 'getMetaBoxFieldGeneratorService',
            'meta_box_generator' => 'getMetaBoxGeneratorService',
            'meta_box_line_generator' => 'getMetaBoxLineGeneratorService',
            'meta_box_sanitizer' => 'getMetaBoxSanitizerService',
            'meta_box_utils' => 'getMetaBoxUtilsService',
            'page_builder_config' => 'getPageBuilderConfigService',
            'page_builder_dal' => 'getPageBuilderDalService',
            'page_builder_manager' => 'getPageBuilderManagerService',
            'page_builder_meta_box' => 'getPageBuilderMetaBoxService',
            'page_builder_utils' => 'getPageBuilderUtilsService',
            'pikart_gallery' => 'getPikartGalleryService',
            'pixcodes' => 'getPixcodesService',
            'plugins_register' => 'getPluginsRegisterService',
            'post_config' => 'getPostConfigService',
            'post_setup' => 'getPostSetupService',
            'post_utils' => 'getPostUtilsService',
            'project_config' => 'getProjectConfigService',
            'project_dal' => 'getProjectDalService',
            'project_register' => 'getProjectRegisterService',
            'project_utils' => 'getProjectUtilsService',
            'site_customizer' => 'getSiteCustomizerService',
            'theme_options_builder' => 'getThemeOptionsBuilderService',
            'theme_options_config' => 'getThemeOptionsConfigService',
            'theme_options_css_filter' => 'getThemeOptionsCssFilterService',
            'theme_options_manager' => 'getThemeOptionsManagerService',
            'theme_options_sanitizer' => 'getThemeOptionsSanitizerService',
            'theme_options_utils' => 'getThemeOptionsUtilsService',
            'theme_options_wrapper' => 'getThemeOptionsWrapperService',
            'theme_setup' => 'getThemeSetupService',
            'utils' => 'getUtilsService',
            'woo_commerce_settings' => 'getWooCommerceSettingsService',
            'woo_commerce_setup' => 'getWooCommerceSetupService',
            'woo_commerce_utils' => 'getWooCommerceUtilsService',
        );

        $this->aliases = array();
    }

    /**
     * {@inheritdoc}
     */
    public function compile()
    {
        throw new LogicException('You cannot compile a dumped frozen container.');
    }

    /**
     * Gets the 'back_compat' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Misc\Back_Compat A Arkfield\Misc\Back_Compat instance.
     */
    protected function getBackCompatService()
    {
        return $this->services['back_compat'] = new \Arkfield\Misc\Back_Compat();
    }

    /**
     * Gets the 'blog_config' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Site\Blog\Blog_Config A Arkfield\Site\Blog\Blog_Config instance.
     */
    protected function getBlogConfigService()
    {
        return $this->services['blog_config'] = new \Arkfield\Site\Blog\Blog_Config();
    }

    /**
     * Gets the 'blog_dal' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Site\Blog\Blog_DAL A Arkfield\Site\Blog\Blog_DAL instance.
     */
    protected function getBlogDalService()
    {
        return $this->services['blog_dal'] = new \Arkfield\Site\Blog\Blog_DAL();
    }

    /**
     * Gets the 'blog_manager' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Site\Blog\Blog_Manager A Arkfield\Site\Blog\Blog_Manager instance.
     */
    protected function getBlogManagerService()
    {
        return $this->services['blog_manager'] = new \Arkfield\Site\Blog\Blog_Manager($this->get('blog_config'));
    }

    /**
     * Gets the 'blog_utils' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Site\Blog\Blog_Utils A Arkfield\Site\Blog\Blog_Utils instance.
     */
    protected function getBlogUtilsService()
    {
        return $this->services['blog_utils'] = new \Arkfield\Site\Blog\Blog_Utils($this->get('blog_config'), $this->get('blog_dal'), $this->get('theme_options_utils'));
    }

    /**
     * Gets the 'bootstrap' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Setup\Bootstrap A Arkfield\Setup\Bootstrap instance.
     */
    protected function getBootstrapService()
    {
        $this->services['bootstrap'] = $instance = new \Arkfield\Setup\Bootstrap();

        $instance->set_theme_setup($this->get('theme_setup'));
        $instance->set_project_register($this->get('project_register'));
        $instance->set_theme_options_manager($this->get('theme_options_manager'));
        $instance->set_plugins_register($this->get('plugins_register'));
        $instance->set_page_builder_manager($this->get('page_builder_manager'));
        $instance->set_mce_manager($this->get('mce_manager'));
        $instance->set_pixcodes($this->get('pixcodes'));
        $instance->set_site_customizer($this->get('site_customizer'));
        $instance->set_blog_manager($this->get('blog_manager'));
        $instance->set_woo_commerce_setup($this->get('woo_commerce_setup'));
        $instance->set_post_setup($this->get('post_setup'));

        return $instance;
    }

    /**
     * Gets the 'custom_walker_comment' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Site\Blog\Custom_Walker_Comment A Arkfield\Site\Blog\Custom_Walker_Comment instance.
     */
    protected function getCustomWalkerCommentService()
    {
        return $this->services['custom_walker_comment'] = new \Arkfield\Site\Blog\Custom_Walker_Comment();
    }

    /**
     * Gets the 'google_fonts_options' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\ThemeCustomizer\Google_Fonts_Options A Arkfield\Admin\ThemeCustomizer\Google_Fonts_Options instance.
     */
    protected function getGoogleFontsOptionsService()
    {
        return $this->services['google_fonts_options'] = new \Arkfield\Admin\ThemeCustomizer\Google_Fonts_Options();
    }

    /**
     * Gets the 'mce_manager' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\MCE_Manager A Arkfield\Admin\MCE_Manager instance.
     */
    protected function getMceManagerService()
    {
        return $this->services['mce_manager'] = new \Arkfield\Admin\MCE_Manager();
    }

    /**
     * Gets the 'meta_box_dal' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\MetaBoxes\Meta_Box_DAL A Arkfield\Admin\MetaBoxes\Meta_Box_DAL instance.
     */
    protected function getMetaBoxDalService()
    {
        return $this->services['meta_box_dal'] = new \Arkfield\Admin\MetaBoxes\Meta_Box_DAL($this->get('meta_box_sanitizer'));
    }

    /**
     * Gets the 'meta_box_field_generator' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\MetaBoxes\Generator\Field_Generator A Arkfield\Admin\MetaBoxes\Generator\Field_Generator instance.
     */
    protected function getMetaBoxFieldGeneratorService()
    {
        return $this->services['meta_box_field_generator'] = new \Arkfield\Admin\MetaBoxes\Generator\Field_Generator($this->get('pikart_gallery'));
    }

    /**
     * Gets the 'meta_box_generator' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\MetaBoxes\Generator\Meta_Box_Generator A Arkfield\Admin\MetaBoxes\Generator\Meta_Box_Generator instance.
     */
    protected function getMetaBoxGeneratorService()
    {
        return $this->services['meta_box_generator'] = new \Arkfield\Admin\MetaBoxes\Generator\Meta_Box_Generator($this->get('meta_box_line_generator'), $this->get('meta_box_dal'));
    }

    /**
     * Gets the 'meta_box_line_generator' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\MetaBoxes\Generator\Line_Generator A Arkfield\Admin\MetaBoxes\Generator\Line_Generator instance.
     */
    protected function getMetaBoxLineGeneratorService()
    {
        return $this->services['meta_box_line_generator'] = new \Arkfield\Admin\MetaBoxes\Generator\Line_Generator($this->get('meta_box_field_generator'));
    }

    /**
     * Gets the 'meta_box_sanitizer' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\MetaBoxes\Meta_Box_Sanitizer A Arkfield\Admin\MetaBoxes\Meta_Box_Sanitizer instance.
     */
    protected function getMetaBoxSanitizerService()
    {
        return $this->services['meta_box_sanitizer'] = new \Arkfield\Admin\MetaBoxes\Meta_Box_Sanitizer();
    }

    /**
     * Gets the 'meta_box_utils' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\MetaBoxes\Meta_Box_Utils A Arkfield\Admin\MetaBoxes\Meta_Box_Utils instance.
     */
    protected function getMetaBoxUtilsService()
    {
        return $this->services['meta_box_utils'] = new \Arkfield\Admin\MetaBoxes\Meta_Box_Utils($this->get('utils'), $this->get('meta_box_dal'), $this->get('meta_box_generator'));
    }

    /**
     * Gets the 'page_builder_config' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\PageBuilder\Page_Builder_Config A Arkfield\PageBuilder\Page_Builder_Config instance.
     */
    protected function getPageBuilderConfigService()
    {
        return $this->services['page_builder_config'] = new \Arkfield\PageBuilder\Page_Builder_Config();
    }

    /**
     * Gets the 'page_builder_dal' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\PageBuilder\Page_Builder_DAL A Arkfield\PageBuilder\Page_Builder_DAL instance.
     */
    protected function getPageBuilderDalService()
    {
        return $this->services['page_builder_dal'] = new \Arkfield\PageBuilder\Page_Builder_DAL($this->get('page_builder_config'), $this->get('meta_box_sanitizer'));
    }

    /**
     * Gets the 'page_builder_manager' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\PageBuilder\Page_Builder_Manager A Arkfield\PageBuilder\Page_Builder_Manager instance.
     */
    protected function getPageBuilderManagerService()
    {
        return $this->services['page_builder_manager'] = new \Arkfield\PageBuilder\Page_Builder_Manager($this->get('page_builder_config'), $this->get('page_builder_dal'), $this->get('page_builder_meta_box'), $this->get('meta_box_utils'));
    }

    /**
     * Gets the 'page_builder_meta_box' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\PageBuilder\Page_Builder_Meta_Box A Arkfield\PageBuilder\Page_Builder_Meta_Box instance.
     */
    protected function getPageBuilderMetaBoxService()
    {
        return $this->services['page_builder_meta_box'] = new \Arkfield\PageBuilder\Page_Builder_Meta_Box($this->get('page_builder_config'), $this->get('page_builder_dal'), $this->get('meta_box_utils'));
    }

    /**
     * Gets the 'page_builder_utils' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\PageBuilder\Page_Builder_Utils A Arkfield\PageBuilder\Page_Builder_Utils instance.
     */
    protected function getPageBuilderUtilsService()
    {
        return $this->services['page_builder_utils'] = new \Arkfield\PageBuilder\Page_Builder_Utils($this->get('page_builder_config'), $this->get('page_builder_dal'), $this->get('utils'));
    }

    /**
     * Gets the 'pikart_gallery' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\Pikart_Gallery A Arkfield\Admin\Pikart_Gallery instance.
     */
    protected function getPikartGalleryService()
    {
        return $this->services['pikart_gallery'] = new \Arkfield\Admin\Pikart_Gallery();
    }

    /**
     * Gets the 'pixcodes' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Misc\Pixcodes A Arkfield\Misc\Pixcodes instance.
     */
    protected function getPixcodesService()
    {
        return $this->services['pixcodes'] = new \Arkfield\Misc\Pixcodes();
    }

    /**
     * Gets the 'plugins_register' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Misc\Plugins_Register A Arkfield\Misc\Plugins_Register instance.
     */
    protected function getPluginsRegisterService()
    {
        return $this->services['plugins_register'] = new \Arkfield\Misc\Plugins_Register();
    }

    /**
     * Gets the 'post_config' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\Post\Post_Config A Arkfield\Admin\Post\Post_Config instance.
     */
    protected function getPostConfigService()
    {
        return $this->services['post_config'] = new \Arkfield\Admin\Post\Post_Config();
    }

    /**
     * Gets the 'post_setup' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\Post\Post_Setup A Arkfield\Admin\Post\Post_Setup instance.
     */
    protected function getPostSetupService()
    {
        return $this->services['post_setup'] = new \Arkfield\Admin\Post\Post_Setup($this->get('post_config'), $this->get('meta_box_utils'));
    }

    /**
     * Gets the 'post_utils' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\Post\Post_Utils A Arkfield\Admin\Post\Post_Utils instance.
     */
    protected function getPostUtilsService()
    {
        return $this->services['post_utils'] = new \Arkfield\Admin\Post\Post_Utils();
    }

    /**
     * Gets the 'project_config' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Project\Project_Config A Arkfield\Project\Project_Config instance.
     */
    protected function getProjectConfigService()
    {
        return $this->services['project_config'] = new \Arkfield\Project\Project_Config();
    }

    /**
     * Gets the 'project_dal' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Project\Project_DAL A Arkfield\Project\Project_DAL instance.
     */
    protected function getProjectDalService()
    {
        return $this->services['project_dal'] = new \Arkfield\Project\Project_DAL();
    }

    /**
     * Gets the 'project_register' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Project\Project_Register A Arkfield\Project\Project_Register instance.
     */
    protected function getProjectRegisterService()
    {
        return $this->services['project_register'] = new \Arkfield\Project\Project_Register($this->get('project_config'), $this->get('meta_box_utils'));
    }

    /**
     * Gets the 'project_utils' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Project\Project_Utils A Arkfield\Project\Project_Utils instance.
     */
    protected function getProjectUtilsService()
    {
        return $this->services['project_utils'] = new \Arkfield\Project\Project_Utils($this->get('project_config'), $this->get('project_dal'), $this->get('utils'));
    }

    /**
     * Gets the 'site_customizer' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Site\Site_Customizer A Arkfield\Site\Site_Customizer instance.
     */
    protected function getSiteCustomizerService()
    {
        return $this->services['site_customizer'] = new \Arkfield\Site\Site_Customizer($this->get('utils'));
    }

    /**
     * Gets the 'theme_options_builder' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\ThemeCustomizer\Theme_Options_Builder A Arkfield\Admin\ThemeCustomizer\Theme_Options_Builder instance.
     */
    protected function getThemeOptionsBuilderService()
    {
        return $this->services['theme_options_builder'] = new \Arkfield\Admin\ThemeCustomizer\Theme_Options_Builder($this->get('theme_options_config'), $this->get('theme_options_wrapper'));
    }

    /**
     * Gets the 'theme_options_config' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\ThemeCustomizer\Theme_Options_Config A Arkfield\Admin\ThemeCustomizer\Theme_Options_Config instance.
     */
    protected function getThemeOptionsConfigService()
    {
        return $this->services['theme_options_config'] = new \Arkfield\Admin\ThemeCustomizer\Theme_Options_Config($this->get('google_fonts_options'));
    }

    /**
     * Gets the 'theme_options_css_filter' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\ThemeCustomizer\Theme_Options_Css_Filter A Arkfield\Admin\ThemeCustomizer\Theme_Options_Css_Filter instance.
     */
    protected function getThemeOptionsCssFilterService()
    {
        return $this->services['theme_options_css_filter'] = new \Arkfield\Admin\ThemeCustomizer\Theme_Options_Css_Filter();
    }

    /**
     * Gets the 'theme_options_manager' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\ThemeCustomizer\Theme_Options_Manager A Arkfield\Admin\ThemeCustomizer\Theme_Options_Manager instance.
     */
    protected function getThemeOptionsManagerService()
    {
        return $this->services['theme_options_manager'] = new \Arkfield\Admin\ThemeCustomizer\Theme_Options_Manager($this->get('theme_options_config'), $this->get('theme_options_utils'), $this->get('theme_options_builder'));
    }

    /**
     * Gets the 'theme_options_sanitizer' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\ThemeCustomizer\Theme_Options_Sanitizer A Arkfield\Admin\ThemeCustomizer\Theme_Options_Sanitizer instance.
     */
    protected function getThemeOptionsSanitizerService()
    {
        return $this->services['theme_options_sanitizer'] = new \Arkfield\Admin\ThemeCustomizer\Theme_Options_Sanitizer();
    }

    /**
     * Gets the 'theme_options_utils' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\ThemeCustomizer\Theme_Options_Utils A Arkfield\Admin\ThemeCustomizer\Theme_Options_Utils instance.
     */
    protected function getThemeOptionsUtilsService()
    {
        return $this->services['theme_options_utils'] = new \Arkfield\Admin\ThemeCustomizer\Theme_Options_Utils($this->get('theme_options_config'), $this->get('theme_options_css_filter'), $this->get('google_fonts_options'));
    }

    /**
     * Gets the 'theme_options_wrapper' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Admin\ThemeCustomizer\Theme_Options_Wrapper A Arkfield\Admin\ThemeCustomizer\Theme_Options_Wrapper instance.
     */
    protected function getThemeOptionsWrapperService()
    {
        return $this->services['theme_options_wrapper'] = new \Arkfield\Admin\ThemeCustomizer\Theme_Options_Wrapper($this->get('theme_options_sanitizer'), $this->get('theme_options_utils'));
    }

    /**
     * Gets the 'theme_setup' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Setup\Theme_Setup A Arkfield\Setup\Theme_Setup instance.
     */
    protected function getThemeSetupService()
    {
        return $this->services['theme_setup'] = new \Arkfield\Setup\Theme_Setup($this->get('theme_options_utils'));
    }

    /**
     * Gets the 'utils' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\Misc\Utils A Arkfield\Misc\Utils instance.
     */
    protected function getUtilsService()
    {
        return $this->services['utils'] = new \Arkfield\Misc\Utils();
    }

    /**
     * Gets the 'woo_commerce_settings' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\WooCommerce\Woo_Commerce_Settings A Arkfield\WooCommerce\Woo_Commerce_Settings instance.
     */
    protected function getWooCommerceSettingsService()
    {
        return $this->services['woo_commerce_settings'] = new \Arkfield\WooCommerce\Woo_Commerce_Settings();
    }

    /**
     * Gets the 'woo_commerce_setup' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\WooCommerce\Woo_Commerce_Setup A Arkfield\WooCommerce\Woo_Commerce_Setup instance.
     */
    protected function getWooCommerceSetupService()
    {
        return $this->services['woo_commerce_setup'] = new \Arkfield\WooCommerce\Woo_Commerce_Setup($this->get('utils'), $this->get('woo_commerce_settings'), $this->get('woo_commerce_utils'));
    }

    /**
     * Gets the 'woo_commerce_utils' service.
     *
     * This service is shared.
     * This method always returns the same instance of the service.
     *
     * @return \Arkfield\WooCommerce\Woo_Commerce_Utils A Arkfield\WooCommerce\Woo_Commerce_Utils instance.
     */
    protected function getWooCommerceUtilsService()
    {
        return $this->services['woo_commerce_utils'] = new \Arkfield\WooCommerce\Woo_Commerce_Utils();
    }
}
