<?php
namespace Arkfield\Admin\MetaBoxes;

use Arkfield\Admin\MetaBoxes\Generator\Meta_Box_Generator;
use Arkfield\Misc\Utils;

if ( ! class_exists( __NAMESPACE__ . '\\Meta_Box_Utils' ) ) {
	/**
	 * Class Meta_Box_Utils
	 * @package Arkfield\Admin\MetaBoxes
	 */
	class Meta_Box_Utils {
		/**
		 * @var Utils
		 */
		protected $utils;

		/**
		 * @var Meta_Box_DAL
		 */
		protected $meta_box_dal;

		/**
		 * @var Meta_Box_Generator
		 */
		protected $meta_box_generator;

		/**
		 * Meta_Box_Utils constructor.
		 *
		 * @param Utils              $utils
		 * @param Meta_Box_DAL       $meta_box_dal
		 * @param Meta_Box_Generator $meta_box_generator
		 */
		public function __construct( Utils $utils, Meta_Box_DAL $meta_box_dal, Meta_Box_Generator $meta_box_generator ) {
			$this->utils              = $utils;
			$this->meta_box_dal       = $meta_box_dal;
			$this->meta_box_generator = $meta_box_generator;
		}

		/**
		 * @param string $post_type
		 * @param string $context
		 * @param null   $post
		 *
		 * @return string
		 */
		public function capture_meta_boxes_content( $post_type, $context, $post = null ) {
			ob_start();
			do_meta_boxes( $post_type, $context, $post );
			$meta_boxes_html = ob_get_contents();
			ob_end_clean();

			return $this->utils->remove_html_outer_tag( $meta_boxes_html );
		}

		/**
		 * @param string $post_type
		 * @param array  $meta_boxes_config
		 */
		public function register_meta_boxes_update( $post_type, array $meta_boxes_config ) {
			$meta_box_dal = $this->meta_box_dal;
			\add_action( 'save_post_' . $post_type, function ( $post_id ) use ( $meta_boxes_config, $meta_box_dal ) {
				foreach ( $meta_boxes_config as $meta_box_config ) {
					$meta_box_dal->save_meta_box_data( $post_id, $meta_box_config );
				}
			} );
		}

		/**
		 * @param string $post_type
		 * @param array  $meta_boxes_config
		 */
		public function register_meta_boxes_generation( $post_type, array $meta_boxes_config ) {
			$self = $this;
			\add_action( 'add_meta_boxes_' . $post_type, function () use ( $post_type, $meta_boxes_config, $self ) {
				$self->generate_meta_boxes( $post_type, $meta_boxes_config );
			} );
		}

		/**
		 * @param string $post_type
		 * @param array  $meta_boxes_config
		 */
		public function register_meta_boxes( $post_type, array $meta_boxes_config ) {
			$this->register_meta_boxes_generation( $post_type, $meta_boxes_config );
			$this->register_meta_boxes_update( $post_type, $meta_boxes_config );
		}

		/**
		 * @param string $post_type
		 * @param array  $meta_boxes_config
		 */
		public function generate_meta_boxes( $post_type, array $meta_boxes_config ) {
			foreach ( $meta_boxes_config as $meta_box_name => $meta_box_config ) {
				$this->generate_meta_box( $post_type, $meta_box_name, $meta_box_config );
			}
		}

		/**
		 * @param string $post_type
		 * @param string $id
		 * @param array  $meta_box_config
		 */
		public function generate_meta_box( $post_type, $id, array $meta_box_config ) {
			$meta_box_config['id'] = $id;
			$this->meta_box_generator->generate( $post_type, $meta_box_config );
		}
	}
}
