<?php
namespace Arkfield\Admin\MetaBoxes\Generator;

use Arkfield\Admin\MetaBoxes\Meta_Box_DAL;

if ( ! class_exists( __NAMESPACE__ . '\\Meta_Box_Generator' ) ) {
	/**
	 * Class Meta_Box_Generator
	 * @package Arkfield\Admin\MetaBoxes\Generator
	 */
	class Meta_Box_Generator {
		const DEFAULT_META_BOX_CONTEXT = 'normal';
		const DEFAULT_META_BOX_PRIORITY = 'high';

		/**
		 * @var Line_Generator
		 */
		protected $line_generator;

		/**
		 * @var Meta_Box_DAL
		 */
		protected $meta_box_dal;

		/**
		 * Meta_Box_Generator constructor.
		 *
		 * @param Line_Generator $line_generator
		 * @param Meta_Box_DAL   $meta_box_dal
		 */
		public function __construct( Line_Generator $line_generator, Meta_Box_DAL $meta_box_dal ) {
			$this->line_generator = $line_generator;
			$this->meta_box_dal   = $meta_box_dal;
		}

		/**
		 * @param string $post_type
		 * @param string $meta_box_name
		 * @param array  $meta_box_config
		 */
		public function generate( $post_type, array $meta_box_config ) {
			$context  = isset( $meta_box_config['context'] ) ? $meta_box_config['context'] : self::DEFAULT_META_BOX_CONTEXT;
			$priority = isset( $meta_box_config['priority'] ) ? $meta_box_config['priority'] : self::DEFAULT_META_BOX_PRIORITY;

			$gen_meta_box_fields_callback = $this->gen_meta_box_fields_callback();

			\add_meta_box( $meta_box_config['id'], $meta_box_config['label'],
				function ( $post ) use ( $meta_box_config, $gen_meta_box_fields_callback ) {
					echo $gen_meta_box_fields_callback( null === $post ? null : $post->ID, $meta_box_config );
				}, $post_type, $context, $priority
			);
		}

		/**
		 * @param int   $post_id
		 * @param array $meta_box_config
		 *
		 * @return string
		 */
		protected function gen_meta_box_fields( $post_id, array $meta_box_config ) {
			$gen_meta_box_fields_callback = $this->gen_meta_box_fields_callback();

			return $gen_meta_box_fields_callback( $post_id, $meta_box_config );
		}

		/**
		 * @return \Closure
		 */
		protected function gen_meta_box_fields_callback() {
			$meta_box_dal            = $this->meta_box_dal;
			$line_generator          = $this->line_generator;
			$generate_nonce_callback = $this->generate_nonce_callback();

			return function ( $post_id, array $meta_box_config ) use ( $meta_box_dal, $line_generator, $generate_nonce_callback ) {
				$content = $generate_nonce_callback( $meta_box_config );

				if ( ! isset( $meta_box_config['fields'] ) ) {
					return $content;
				}

				foreach ( $meta_box_config['fields'] as $field_name => $field_config ) {
					$field_config['value'] = $meta_box_dal->get_field_value( $post_id, $field_config );
					$content .= $line_generator->generate( $field_config );
				}

				return $content;
			};
		}

		/**
		 * @param array $nonce
		 *
		 * @return string
		 */
		protected function generate_nonce( array $meta_box_config ) {
			$generate_nonce_callback = $this->generate_nonce_callback();

			return $generate_nonce_callback( $meta_box_config );
		}

		/**
		 * @return \Closure
		 */
		protected function generate_nonce_callback() {
			return function ( $meta_box_config ) {
				return isset ( $meta_box_config['nonce'] )
					? \wp_nonce_field( $meta_box_config['nonce']['action'], $meta_box_config['nonce']['name'], true, false )
					: '';
			};
		}
	}
}