<?php
namespace Arkfield\Admin\Post;

if ( ! class_exists( __NAMESPACE__ . '\Post_Config' ) ) {
	/**
	 * Class Post_Config
	 * @package Arkfield\Admin
	 */
	class Post_Config {
		const POST_TYPE = 'post';
		const POST_DB_PREFIX = 'pikart_';

		/**
		 * @return array
		 */
		public function get_meta_boxes_config() {
			return array(
				'audio_post_format' => array(
					'label'  => esc_html__( 'Audio Post Format', 'arkfield' ),
					'nonce'  => array(
						'action' => self::POST_DB_PREFIX . 'audio_post_format',
						'name'   => self::POST_DB_PREFIX . 'audio_post_format_nonce'
					),
					'fields' => array(
						array(
							'id'          => self::POST_DB_PREFIX . 'audio_link',
							'type'        => 'url',
							'label'       => esc_html__( 'Audio Link', 'arkfield' ),
							'description' => esc_html__( 'Insert here the audio link from Media Library', 'arkfield' ),
						)
					)
				)
			);
		}
	}
}