<?php
namespace Arkfield\Admin\Post;

use Arkfield\Admin\MetaBoxes\Meta_Box_Utils;

if ( ! class_exists( __NAMESPACE__ . '\Post_Setup' ) ) {
	/**
	 * Class Post_Setup
	 * @package Arkfield\Admin
	 */
	class Post_Setup {
		/**
		 * @var Post_Config
		 */
		protected $post_config;

		/**
		 * @var Meta_Box_Utils
		 */
		protected $meta_box_utils;

		/**
		 * Post_Setup constructor.
		 *
		 * @param Post_Config    $post_config
		 * @param Meta_Box_Utils $meta_box_utils
		 */
		public function __construct( Post_Config $post_config, Meta_Box_Utils $meta_box_utils ) {
			$this->post_config    = $post_config;
			$this->meta_box_utils = $meta_box_utils;
		}

		public function run() {
			$this->meta_box_utils->register_meta_boxes(
				Post_Config::POST_TYPE, $this->post_config->get_meta_boxes_config() );
			$this->enqueue_post_admin_scripts();
		}

		protected function enqueue_post_admin_scripts() {
			\add_action( 'admin_enqueue_scripts', function ( $hook ) {
				$current_screen = get_current_screen();

				if ( Post_Config::POST_TYPE === $current_screen->post_type
				     && ( 'post-new.php' === $hook || 'post.php' === $hook )
				) {
					wp_enqueue_script( 'arkfield' . '-admin-post', ARKFIELD_THEME_JS_URI . '/admin/post.js',
						array( 'jquery' ), ARKFIELD_THEME_VERSION, true
					);
				}
			} );
		}
	}
}