<?php
namespace Arkfield\Misc;

use Arkfield\Admin\Post\Post_Utils;
use Arkfield\Admin\ThemeCustomizer\Theme_Options_Utils;
use Arkfield\PageBuilder\Page_Builder_Utils;
use Arkfield\Project\Project_DAL;
use Arkfield\Project\Project_Utils;
use Arkfield\Setup\Bootstrap;
use Arkfield\Site\Blog\Blog_DAL;
use Arkfield\Site\Blog\Blog_Utils;
use Arkfield\Site\Blog\Custom_Walker_Comment;
use Arkfield\WooCommerce\Woo_Commerce_Settings;
use Arkfield\WooCommerce\Woo_Commerce_Utils;

if ( ! class_exists( __NAMESPACE__ . '\\Service' ) ) {

	/**
	 * Service container wrapper used for service type hinting
	 *
	 * Class Service
	 * @package Arkfield\Misc
	 */
	class Service {

		/**
		 * @return Utils
		 */
		public static function utils() {
			return Service_Container::get_service( 'utils' );
		}

		/**
		 * @return Theme_Options_Utils
		 */
		public static function theme_options_utils() {
			return Service_Container::get_service( 'theme_options_utils' );
		}

		/**
		 * @return Project_Utils
		 */
		public static function project_utils() {
			return Service_Container::get_service( 'project_utils' );
		}

		/**
		 * @return Project_DAL
		 */
		public static function project_dal() {
			return Service_Container::get_service( 'project_dal' );
		}

		/**
		 * @return Custom_Walker_Comment
		 */
		public static function custom_walker_comment() {
			return Service_Container::get_service( 'custom_walker_comment' );
		}

		/**
		 * @return Bootstrap
		 */
		public static function bootstrap() {
			return Service_Container::get_service( 'bootstrap' );
		}

		/**
		 * @return Back_Compat
		 */
		public static function back_compat() {
			return Service_Container::get_service( 'back_compat' );
		}

		/**
		 * @return Blog_Utils
		 */
		public static function blog_utils() {
			return Service_Container::get_service( 'blog_utils' );
		}

		/**
		 * @return Blog_DAL
		 */
		public static function blog_dal() {
			return Service_Container::get_service( 'blog_dal' );
		}

		/**
		 * @return Page_Builder_Utils
		 */
		public static function page_builder_utils() {
			return Service_Container::get_service( 'page_builder_utils' );
		}

		/**
		 * @return Woo_Commerce_Settings
		 */
		public static function woo_commerce_settings() {
			return Service_Container::get_service( 'woo_commerce_settings' );
		}

		/**
		 * @return Woo_Commerce_Utils
		 */
		public static function woo_commerce_utils() {
			return Service_Container::get_service( 'woo_commerce_utils' );
		}

		/**
		 * @return Post_Utils
		 */
		public static function post_utils() {
			return Service_Container::get_service( 'post_utils' );
		}
	}
}