<?php
namespace Arkfield\Site\Blog;

if ( ! class_exists( __NAMESPACE__ . '\\Custom_Walker_Comment' ) ) {
	/**
	 * Class Custom_Walker_Comment
	 * @package Arkfield\Site\Blog
	 */
	class Custom_Walker_Comment extends \Walker_Comment {
		/**
		 * Output a single comment.
		 *
		 * @param object $comment Comment to display.
		 * @param int    $depth   Depth of comment.
		 * @param array  $args    An array of arguments.
		 */
		protected function comment( $comment, $depth, $args ) {
			$this->html5_comment( $comment, $depth, $args );
		}

		/**
		 * Output a comment in the HTML5 format.
		 *
		 * @param object $comment Comment to display.
		 * @param int    $depth   Depth of comment.
		 * @param array  $args    An array of arguments.
		 */
		protected function html5_comment( $comment, $depth, $args ) {
			if ( 'div' === $args['style'] ) {
				$tag       = 'div';
				$add_below = 'comment';
			} else {
				$tag       = 'li';
				$add_below = 'div-comment';
			}
			?>
			<<?php echo $tag ?><?php \comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php \comment_ID() ?>">
			<?php if ( 'div' !== $args['style'] ) : ?>
				<div id="div-comment-<?php \comment_ID() ?>" class="comment-body">
			<?php endif; ?>

			<div class="flexbox comment-body__bar">
				<div class="flexbox__item comment-reply">
					<?php \comment_reply_link( array_merge( $args,
						array(
							'add_below'  => $add_below,
							'depth'      => $depth,
							'max_depth'  => $args['max_depth'],
							'reply_text' => '+',
						) ) ); ?>
				</div>

				<div class="flexbox__item comment-data">
					<div class="comment-author vcard">
						<?php printf( '<cite class="fn">%s</cite>', \get_comment_author_link() ); ?>
					</div>

					<div class="comment-meta commentmetadata"><a
							href="<?php echo htmlspecialchars( \get_comment_link( $comment->comment_ID ) ); ?>">
							<?php
							/* translators: 1: date, 2: time */
							printf( esc_html__( '%1$s / %2$s', 'arkfield' ), \get_comment_date(), \get_comment_time() ); ?></a>
					</div>

					<?php \edit_comment_link( esc_html__( 'edit', 'arkfield' ), '  ', '' ); ?>
				</div>
			</div>

			<?php \comment_text(); ?>

			<?php if ( 0 === (int) $comment->comment_approved ) : ?>
				<em class="awaiting-comment"><?php esc_html_e( 'Your comment is awaiting moderation.',
						'arkfield' ); ?></em>
			<?php endif;
			if ( 'div' !== $args['style'] ) : ?>
				</div>
			<?php endif;
		}
	}
}
