<?php
namespace Arkfield\Site;

use Arkfield\Misc\Utils;

if ( ! class_exists( __NAMESPACE__ . '\Site_Customizer' ) ) {
	/**
	 * Class Site_Customizer
	 * @package Arkfield\Site
	 */
	class Site_Customizer {

		/**
		 * @var Utils
		 */
		protected $utils;

		/**
		 * Site_Customizer constructor.
		 *
		 * @param Utils $utils
		 */
		public function __construct( Utils $utils ) {
			$this->utils = $utils;
		}

		public function customize() {
			$this->init_widgets();
			$this->edit_menu_item_attributes();
		}

		protected function init_widgets() {
			\add_action( 'widgets_init', function () {
				\register_sidebar( array(
					'name'          => esc_html__( 'Footer Widget Area', 'arkfield' ),
					'id'            => 'arkfield' . '_footer_widget_area',
					'description'   => esc_html__( 'Add widgets here to appear in your footer widget area.', 'arkfield' ),
					'before_widget' => '<article id="%1$s" class="widget-item %2$s">',
					'after_widget'  => '</article>',
					'before_title'  => '<h4>',
					'after_title'   => '</h4>',
				) );
			} );
		}

		protected function edit_menu_item_attributes() {
			$utils = $this->utils;
			\add_filter( 'nav_menu_link_attributes', function ( $attributes, $item ) use ( $utils ) {
				if ( 'custom' === $item->type ) {
					$attributes['class'] = isset( $attributes['class'] ) ? ' ' : '';
					$attributes['class'] .= 'icon-e-' . $utils->get_url_domain( $item->url, false );
				}

				return $attributes;
			}, 10, 2 );
		}
	}

}