<?php
namespace Arkfield\WooCommerce;

if ( ! class_exists( __NAMESPACE__ . '\Woo_Commerce_Settings' ) ) {
	/**
	 * Class Woo_Commerce_Settings
	 * @package Arkfield\Woocommerce
	 */
	class Woo_Commerce_Settings {
		const SETTING_PREFIX = 'woocommerce_';

		/**
		 * @var array
		 */
		protected $custom_settings = array();

		/**
		 * Woo_Commerce_Settings constructor.
		 */
		public function __construct() {
			$all_settings = $this->get_all_settings();

			foreach ( $all_settings as $filter => $custom_settings ) {
				foreach ( $custom_settings as $setting ) {
					$this->custom_settings[ $setting['id'] ] = $setting;
				}
			}
		}

		public function manage_settings() {
			$this->add_product_settings();
		}

		/**
		 * @param string $id
		 *
		 * @return string
		 */
		public function get_setting( $id ) {
			$setting_id = $this->build_setting_id( $id );
			$default    = isset( $this->custom_settings[ $setting_id ]['default'] )
				? $this->custom_settings[ $setting_id ]['default'] : false;

			return \get_option( $setting_id, $default );
		}

		protected function add_product_settings() {
			$all_settings = $this->get_all_settings();

			foreach ( $all_settings as $filter => $custom_settings ) {
				\add_filter( $filter, function ( $settings ) use ( $custom_settings ) {
					return array_merge( $settings, $custom_settings );
				} );
			}
		}

		protected function get_all_settings() {
			return array(
				'woocommerce_general_settings' => array(
					array(
						'id'    => 'general_misc',
						'type'  => 'title',
						'title' => esc_html__( 'Arkfield Options', 'arkfield' ),
					),
					array(
						'id'      => $this->build_setting_id( 'header_cart_display' ),
						'type'    => 'checkbox',
						'title'   => esc_html__( 'Cart display', 'arkfield' ),
						'desc'    => esc_html__( 'Check this if you want the cart displayed in the header', 'arkfield' ),
						'default' => 'yes',
					),
					array(
						'id'   => 'general_misc',
						'type' => 'sectionend',
					)
				),
				'woocommerce_product_settings' => array(
					array(
						'id'    => 'products_display_misc',
						'type'  => 'title',
						'title' => esc_html__( 'Arkfield Options', 'arkfield' ),
					),
					array(
						'id'      => $this->build_setting_id( 'products_speed' ),
						'type'    => 'checkbox',
						'title'   => esc_html__( 'Products Speed', 'arkfield' ),
						'desc'    => esc_html__( 'Check this if you want your products moving faster on Shop Page', 'arkfield' ),
						'default' => 'yes',
					),
					array(
						'id'   => 'products_display_misc',
						'type' => 'sectionend',
					)
				)
			);
		}

		/**
		 * @param string $setting_id
		 *
		 * @return string
		 */
		protected function build_setting_id( $setting_id ) {
			return self::SETTING_PREFIX . $setting_id;
		}
	}
}
