<?php
namespace Arkfield\WooCommerce;

if ( ! class_exists( __NAMESPACE__ . '\Woo_Commerce_Utils' ) ) {
	/**
	 * Class Woo_Commerce_Utils
	 * @package Arkfield\WooCommerce
	 */
	class Woo_Commerce_Utils {
		/**
		 * @return string
		 */
		public function capture_product_subcategories_content() {
			ob_start();
			\woocommerce_product_subcategories();
			$content = ob_get_contents();
			ob_end_clean();

			return $content;
		}

		/**
		 * @return bool
		 */
		public function is_shop_activated() {
			return class_exists( 'WooCommerce' );
		}

		/**
		 * Retrieve list of products matching criteria and loops through them applying the specified callback
		 *
		 * @param array    $args
		 * @param \closure $callback
		 */
		public function get_products_and_process_loop( array $args, \closure $callback ) {
			$query = new \WP_Query( array_merge( array(
				'post_type'      => 'product',
				'no_found_rows'  => true,
				'posts_per_page' => 9,
				'orderby'        => 'date',
				'order'          => 'DESC',
			), $args ) );

			if ( $query->have_posts() ) {
				while ( $query->have_posts() ) {
					$query->the_post();
					$callback();
				}
			}

			\wp_reset_postdata();
		}
	}
}
