<?php
use Arkfield\Misc\Service;

$theme_options_utils = Service::theme_options_utils();
$logo_image          = $theme_options_utils->get_custom_option( 'logo_image' );
$logo_text           = $theme_options_utils->get_custom_option( 'logo_text' );
?>

<div class="navigation navigation--logo">
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>">

		<?php if ( ! empty( $logo_image ) || ! empty( $logo_text ) ):
			$logo_size = $theme_options_utils->get_logo_size();

			if ( empty( $logo_image ) ): ?>
				<span id="logo-text"><?php echo esc_html( $logo_text ) ?></span>
			<?php else : ?>
				<img id="logo-image" src="<?php echo esc_url( $logo_image ) ?>"
				     alt="<?php echo esc_attr( $logo_text ) ?>"
				     data-width="<?php echo esc_attr( $logo_size['width'] ) ?>"
				     data-height="<?php echo esc_attr( $logo_size['height'] ) ?>"
				     data-max-width="<?php echo esc_attr( $logo_size['max-width'] ) ?>"
				     data-max-height="<?php echo esc_attr( $logo_size['max-height'] ) ?>"/>
			<?php endif;

		endif; ?>

	</a>
</div>