<?php
$commenter     = wp_get_current_commenter();
$aria_req      = get_option( 'require_name_email' ) ? "aria-required='true'" : '';
$comment_field = '<p class="comment-form-comment"><textarea id="comment" name="comment" aria-required="true" rows="10"'
                 . ' placeholder="' . esc_html__( 'Your comment', 'arkfield' ) . '" ></textarea></p>';
$fields        = apply_filters( 'comment_form_default_fields', array(
		'author' => '<input id="author" name="author" type="text" size="30"
		 				placeholder="' . esc_html__( 'Name', 'arkfield' ) . '" class="blog-form-input comment-form-author" ' . $aria_req
		            . ' value="' . esc_attr( $commenter['comment_author'] ) . '" />',
		'email'  => '<input id="email" name="email" type="text" class="blog-form-input comment-form-email"
		 				placeholder="' . esc_html__( 'Email', 'arkfield' ) . '" size="30" ' . $aria_req
		            . ' value="' . esc_attr( $commenter['comment_author_email'] ) . '" />',
		'url'    => '<input id="url" name="url" type="text" class="blog-form-input comment-form-url"
		 				placeholder="' . esc_html__( 'Website', 'arkfield' ) . '" size="30"
						value="' . esc_attr( $commenter['comment_author_url'] ) . '" />'
	)
);

comment_form( array(
	'label_submit'         => '',
	'title_reply'          => esc_html__( 'What do you think', 'arkfield' ),
	'comment_form_top'     => '',
	'comment_notes_before' => '',
	'comment_notes_after'  => '',
	'label_submit'         => esc_html__( 'POST YOUR COMMENT', 'arkfield' ),
	'class_submit'         => 'pikode pikode--btn btn btn--large btn--gamma',
	'comment_field'        => $comment_field,
	'fields'               => $fields,
) );