<?php
/**
 * Display single product reviews (comments)
 *
 * @author        WooThemes
 * @package       WooCommerce/Templates
 * @version       2.3.2
 */
global $product;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! comments_open() ) {
	return;
}

?>
<div id="reviews">
	<div id="comments">

		<?php if ( have_comments() ) : ?>

			<ol class="commentlist">
				<?php wp_list_comments( apply_filters( 'woocommerce_product_review_list_args', array( 'callback' => 'woocommerce_comments' ) ) ); ?>
			</ol>

			<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
				<nav class="woocommerce-pagination">
					<?php paginate_comments_links( apply_filters( 'woocommerce_comment_pagination_args', array(
						'prev_text' => '&larr;',
						'next_text' => '&rarr;',
						'type'      => 'list',
					) ) ); ?>
				</nav>
			<?php endif;

		else : ?>

			<p class="woocommerce-noreviews"><?php esc_html_e( 'There are no reviews yet.', 'woocommerce' ); ?></p>

		<?php endif; ?>
	</div>

	<?php if ( get_option( 'woocommerce_review_rating_verification_required' ) === 'no' || wc_customer_bought_product( '', get_current_user_id(), $product->id ) ) : ?>

		<div id="review_form_wrapper">
			<div id="review_form">
				<?php
				$commenter = wp_get_current_commenter();

				$comment_form = array(
					'title_reply'          => have_comments() ? esc_html__( 'Add review', 'arkfield' )
						: esc_html__( 'Be the first to review', 'woocommerce' ) . ' &ldquo;' . get_the_title() . '&rdquo;',
					'title_reply_to'       => esc_html__( 'Leave a Reply to %s', 'woocommerce' ),
					'comment_notes_before' => '',
					'comment_notes_after'  => '',
					'fields'               => array(
						'author' => '<input id="author" name="author" type="text" size="30"
		 				                    placeholder="' . esc_attr__( 'Name', 'woocommerce' ) . '"class="blog-form-input comment-form-author"
							                value="' . esc_attr( $commenter['comment_author'] ) . '" />',
						'email'  => '<input id="email" name="email" type="text" class="blog-form-input comment-form-email"
		 				                    placeholder="' . esc_attr__( 'Email', 'woocommerce' ) . '" size="30"
		 				                    value="' . esc_attr( $commenter['comment_author_email'] ) . '" />',
					),
					'label_submit'         => esc_html__( 'Add your review', 'arkfield' ),
					'id_submit'            => 'wc-submit',
					'class_submit'         => 'pikode pikode--btn btn btn--large btn--gamma',
					'logged_in_as'         => '',
					'comment_field'        => ''
				);

				if ( $account_page_url = wc_get_page_permalink( 'myaccount' ) ) :
					$must_log_in_message = wp_kses( __( 'You must be <a href="%s">logged in</a> to post a review.', 'woocommerce' ), array( 'a' => array( 'href' => array() ) ) );
					$comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf( $must_log_in_message, esc_url( $account_page_url ) ) . '</p>';
				endif;

				if ( get_option( 'woocommerce_enable_review_rating' ) === 'yes' ) :
					$comment_form['fields'][2] =
						'<select name="rating" id="rating">
								<option value="">' . esc_html__( 'Rate&hellip;', 'woocommerce' ) . '</option>
								<option value="5">' . esc_html__( 'Perfect', 'woocommerce' ) . '</option>
								<option value="4">' . esc_html__( 'Good', 'woocommerce' ) . '</option>
								<option value="3">' . esc_html__( 'Average', 'woocommerce' ) . '</option>
								<option value="2">' . esc_html__( 'Not that bad', 'woocommerce' ) . '</option>
								<option value="1">' . esc_html__( 'Very Poor', 'woocommerce' ) . '</option>
							</select>';
				endif;

				$comment_form['comment_field'] .= '<p class="comment-form-comment"><textarea name="comment" aria-required="true" rows="10" placeholder="'
				                                  . esc_attr__( 'Your review', 'woocommerce' ) . '" ></textarea></p>';

				comment_form( apply_filters( 'woocommerce_product_review_comment_form_args', $comment_form ) );
				?>
			</div>
		</div>

	<?php else : ?>

		<p class="woocommerce-verification-required"><?php esc_html_e( 'Only logged in customers who have purchased this product may leave a review.', 'woocommerce' ); ?></p>

	<?php endif; ?>

	<div class="clear"></div>
</div>
