"use strict";

(function ($) {
    $(document).ready(function () {

        var pageMetaBoxManager = {
            metaBoxMaxIndex: 0,
            addSectionElement: $('#page_builder_add_section'),
            sectionPrefix: 'page_builder_sections',
            metaBoxSelector: 'div[id^="page_builder_sections"]',
            addPageMetaBoxClickEventCallback: function (e) {
                e.preventDefault();

                $.ajax({
                    method: "POST",
                    url: wp.ajax.settings.url,
                    data: {
                        action: 'page_builder_add_meta_box',
                        metaBoxNewIndex: pageMetaBoxManager.metaBoxMaxIndex + 1
                    },
                    success: function (response) {
                        if (response.success) {
                            pageMetaBoxManager.setupSection(response.data);
                        }
                    }
                });
            },
            setupSection: function (data) {
                pageMetaBoxManager.addSectionElement.before(data);
                pageMetaBoxManager.metaBoxMaxIndex++;
                pageMetaBoxManager.disableMetaBoxDragging();
                pageMetaBoxManager.removePageMetaBoxClickEvent();
                sectionContentTypeManager.initSectionContent(pageMetaBoxManager.metaBoxMaxIndex);
                pageMetaBoxManager.resetPostboxToggles();
                pageMetaBoxManager.initWpEditor('section_content_' + pageMetaBoxManager.metaBoxMaxIndex);
            },

            initWpEditor: function (wpEditorId) {
                quicktags({id: wpEditorId});
                QTags._buttonsInit();
                tinyMCE.execCommand('mceAddEditor', false, wpEditorId);
            },

            addPageMetaBoxClickEvent: function () {
                pageMetaBoxManager.addSectionElement.find('span').click(this.addPageMetaBoxClickEventCallback);

                var boxAdded = false;
                pageMetaBoxManager.addSectionElement.find('span').click(function () {
                    var $this = $(this);

                    if( boxAdded == false ) {
                        boxAdded = true;
                        $this.append('<i class="icon-refresh"></i>');
                        $('body').on('DOMNodeInserted', 'div[id^="page_builder_sections"]', function () {
                            $this.find('.icon-refresh').remove();
                            boxAdded = false;
                        });
                    }
                });
            },
            removePageMetaBoxClickEvent: function () {
                var removeSectionElements = $('.remove-page-meta-box-custom-button');
                removeSectionElements.off('click');
                removeSectionElements.on('click', function (e) {
                    e.preventDefault();
                    $(this).closest(pageMetaBoxManager.metaBoxSelector).remove();
                });
            },
            disableMetaBoxDragging: function () {
                $('.meta-box-sortables').sortable({disabled: true});
                $('.postbox .hndle').css('cursor', 'default');
            },
            initMetaBoxMaxIndex: function () {
                var metaBoxIndexes = [];

                $(pageMetaBoxManager.metaBoxSelector).each(function () {
                    metaBoxIndexes.push(parseInt($(this).attr('id').replace(pageMetaBoxManager.sectionPrefix, '')));
                });

                if (metaBoxIndexes.length > 0) {
                    this.metaBoxMaxIndex = Math.max.apply(Math, metaBoxIndexes);
                }
            },
            prepareAddSection: function () {
                var addSectionElement = pageMetaBoxManager.addSectionElement;
                addSectionElement.find('.inside').remove();
                addSectionElement.find('.handlediv').remove();
                addSectionElement.find('span').css('cursor', 'pointer');

                if (this.metaBoxMaxIndex > 0) {
                    $('#' + this.sectionPrefix + this.metaBoxMaxIndex).after(addSectionElement);
                } else {
                    $('#normal-sortables').prepend(addSectionElement);
                }
            },
            resetPostboxToggles: function () {
                var postboxElements = ['.postbox .hndle', '.postbox .handlediv', '.hide-postbox-tog',
                    '.postbox a.dismiss', '.columns-prefs input[type="radio"]'];

                postboxElements.forEach(function (element) {
                    $(element).off('click.postboxes');
                });

                $('.postbox .hndle a').unbind('click');
                postboxes.add_postbox_toggles('page');
            },
            hideSectionFromScreenOptions: function () {
                $('#screen-meta').find('.metabox-prefs').find('label[for^="page_builder_sections"]').remove();
            },
            run: function () {
                this.initMetaBoxMaxIndex();
                this.prepareAddSection();
                this.addPageMetaBoxClickEvent();
                this.disableMetaBoxDragging();
                this.removePageMetaBoxClickEvent();
                this.hideSectionFromScreenOptions();
            }
        };

        var sectionContentTypeManager = {
            initSectionContent: function (metaBoxMaxIndex) {
                var sectionElement = $('#page_builder_sections' + metaBoxMaxIndex);
                $('.page-builder-section-projects-display').change(this.changeProjectsDisplay);
                sectionElement.find('.page-builder-section-content-type').change(this.changeContentType).change();
            },

            changeContentType: function () {
                var //sectionIndex = $(this).attr('id').replace(/\w+\[(\d+)\].+/i, '$1'),
                    sectionElement = $(this).closest(pageMetaBoxManager.metaBoxSelector),
                    contentType = $(this).val(),
                    sectionHiddenFields = ["content", "nb_projects", "projects_speed", "nb_posts",
                        "posts_speed", "nb_products", "products_speed",
                        "projects_display", "gmap_latitude", "gmap_longitude"],
                    sectionVisibleFields = ["content_type", "remove_section"],
                    contentTypeConfig = {
                        default: ["content"],
                        projects: ["projects_display", "nb_projects"],
                        posts: ["nb_posts", "posts_speed"],
                        products: ["nb_products", "products_speed"],
                        contact_map: ["gmap_latitude", "gmap_longitude"]
                    };
                var getSectionElementsSelectorByFieldName = function (fieldName, matcher) {
                    return '[id' + matcher + '="' + fieldName + '"], [name' + matcher + '="' + fieldName + '"]';
                };

                var sectionInputElements = sectionElement
                    .find(getSectionElementsSelectorByFieldName('page_builder_sections', '^'));

                var getMetaBoxByFieldName = function (fieldName) {
                    var selector = getSectionElementsSelectorByFieldName('[' + fieldName + ']', '*');
                    return sectionInputElements.filter(selector).closest('.meta-box-custom-field');
                };

                sectionHiddenFields.forEach(function (fieldName) {
                    getMetaBoxByFieldName(fieldName).hide();
                });

                sectionVisibleFields.concat(contentTypeConfig[contentType]).forEach(function (fieldName) {
                    getMetaBoxByFieldName(fieldName).show();
                });

                sectionElement.find('.page-builder-section-projects-display').change();
            },

            changeProjectsDisplay: function () {
                var sectionElement = $(this).closest(pageMetaBoxManager.metaBoxSelector),
                    contentType = sectionElement.find('.page-builder-section-content-type').val(),
                    projectsSpeedElement = sectionElement.find('[name^="page_builder_sections"]')
                        .filter('[name*="[projects_speed]"]').closest('.meta-box-custom-field');

                if ($(this).val() === 'fullgrid' && contentType === 'projects') {
                    projectsSpeedElement.show();
                } else {
                    projectsSpeedElement.hide();
                }
            },

            init: function () {
                $(pageMetaBoxManager.metaBoxSelector).find('.meta-box-custom-field ').hide();
                $('.page-builder-section-projects-display').change(this.changeProjectsDisplay);
                $('.page-builder-section-content-type').change(this.changeContentType).change();
            }
        };

        var pageTemplateManager = {
            changeTemplate: function () {
                var templateName = $(this).val(),
                    metaBoxesData = {
                        page_builder_add_section: "page-builder"
                    };

                var sections = $(pageMetaBoxManager.metaBoxSelector),
                    wpEditor = $('#postdivrich');
                if (templateName.indexOf('page-builder') > -1) {
                    wpEditor.hide();
                    sections.show();
                } else {
                    wpEditor.show(100, function () {
                        $(this).find('#wp-content-wrap').css({'padding-top': '55px'});
                        $(this).find('#wp-content-editor-tools, .mce-toolbar-grp').css({'width': '100%'});
                    });
                    sections.hide();
                }

                Object.keys(metaBoxesData).forEach(function (metaBoxId) {
                    var metaBoxTemplateName = 'templates/' + metaBoxesData[metaBoxId] + '.php',
                        metaBox = $('#' + metaBoxId);
                    if (templateName === metaBoxTemplateName) {
                        metaBox.show();
                    } else {
                        metaBox.hide();
                    }
                });
            },

            init: function () {
                $('#page_template').change(this.changeTemplate).change();
            }
        };

        if (pagenow === 'page') {
            pageTemplateManager.init();
            pageMetaBoxManager.run();
            sectionContentTypeManager.init();
        }
    });
})(jQuery);