<?php
use Arkfield\Misc\Service; ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<?php Service::utils()->get_partial( 'header/head' ); ?>

<body <?php body_class(); ?>>

<?php Service::utils()->get_partial( 'header/preloader' ); ?>

<!-- Navigation -->
<header id="site-header">
	<div class="header__container">

		<div class="flexbox">

			<div class="flexbox__item flexbox__item--logo">

				<?php Service::utils()->get_partial( 'header/logo' ); ?>

				<div class="flexbox__item__button">
					<a class="navigation navigation--btn" href="#">
						<span class="icon-reorder"></span>
					</a>
				</div>
			</div>

			<div class="flexbox__item flexbox__item--menus">

				<?php if ( Service::woo_commerce_utils()->is_shop_activated()
				           && Service::woo_commerce_settings()->get_setting( 'header_cart_display' ) === 'yes'
				):
					$header_cart_display = WC()->cart->get_cart_contents_count() > 0 ? '' : 'none'; ?>

					<div class="flexbox__item--wc-cart" style="display: <?php echo $header_cart_display ?>">
						<div class="wc-cart-container">
							<a class="wc-cart--link icon-shopping-cart"
							   href="<?php echo esc_url( WC()->cart->get_cart_url() ) ?>">
								<span class="wc-cart--items-number">
									<?php echo esc_html( WC()->cart->get_cart_contents_count() ) ?>
								</span>
								<span class="wc-cart--link__text">
									<?php esc_html_e( 'View cart', 'arkfield' ); ?>
								</span>
							</a>
						</div>
					</div>

				<?php endif ?>

				<div class="flexbox__item--social">
					<?php Service::utils()->get_partial( 'header/social-menu' ); ?>
				</div>

				<div class="flexbox__item--main">
					<?php Service::utils()->get_partial( 'header/primary-menu' ); ?>
				</div>
			</div>

		</div>

	</div>
</header>