<?php
namespace Arkfield\Admin\Post;

if ( ! class_exists( __NAMESPACE__ . '\Post_Utils' ) ) {
	/**
	 * Class Post_Utils
	 * @package Arkfield\Admin\Post
	 */
	class Post_Utils {
		/**
		 * @param string $post_id
		 *
		 * @return array
		 */
		public function get_post_meta( $post_id ) {
			$meta = \get_post_meta( $post_id );

			$final_meta = array();
			foreach ( $meta as $key => $value ) {
				$final_meta[ str_replace( Post_Config::POST_DB_PREFIX, '', $key ) ] = $value[0];
			}

			return $final_meta;
		}

		/**
		 * @param int $post_id
		 *
		 * @return string
		 */
		public function get_audio_link( $post_id ) {
			return \get_post_meta( $post_id, Post_Config::POST_DB_PREFIX . 'audio_link', true );
		}
	}
}