<?php
use Arkfield\Misc\Service;

Service::back_compat()->build_theme_title();

if ( ! function_exists( 'get_the_archive_title' ) ) {
	/**
	 * Retrieve the archive title based on the queried object.
	 *
	 * Used for backwards compatibility since it's only available in WP 4.1
	 *
	 * @return string Archive title.
	 */
	function get_the_archive_title() {
		return Service::back_compat()->get_the_archive_title();
	}
}

if ( ! function_exists( 'get_the_archive_description' ) ) {
	/**
	 * Retrieve category, tag, or term description.
	 *
	 * Used for backwards compatibility since it's only available in WP 4.1
	 *
	 * @return string Archive description.
	 */
	function get_the_archive_description() {
		return Service::back_compat()->get_the_archive_description();
	}
}

if ( ! function_exists( 'get_the_posts_pagination' ) ) {

	/**
	 * Return a paginated navigation to next/previous set of posts,
	 * when applicable.
	 *
	 * Used for backwards compatibility since it's only available in WP 4.1
	 *
	 * @param array $args               {
	 *                                  Optional. Default pagination arguments, {@see paginate_links()}.
	 *
	 * @type string $screen_reader_text Screen reader text for navigation element.
	 *                                      Default 'Posts navigation'.
	 * }
	 * @return string Markup for pagination links.
	 */
	function get_the_posts_pagination( $args = array() ) {
		return Service::back_compat()->get_the_posts_pagination( $args );
	}
}

