<?php
/**
 * Register all required/recommended plugins
 *
 * @package    Arkfield
 * @subpackage Plugins
 */

namespace Arkfield\Misc;

if ( ! class_exists( __NAMESPACE__ . '\\Plugins_Register' ) ) {
	/**
	 * Class Plugins_Register
	 * @package Arkfield\Misc
	 */
	class Plugins_Register {
		/**
		 * Register all required/recommended plugins
		 */
		public function register() {
			add_action( 'tgmpa_register', function () {
				$plugins = array(
					array(
						'name'     => 'PixCodes',
						'slug'     => 'pixcodes',
						'required' => true,
					),
					array(
						'name'     => 'Favicon by RealFaviconGenerator',
						'slug'     => 'favicon-by-realfavicongenerator',
						'required' => false,
					),
					array(
						'name'     => 'Contact Form 7',
						'slug'     => 'contact-form-7',
						'required' => false,
					),
					array(
						'name'     => 'WooCommerce',
						'slug'     => 'woocommerce',
						'required' => false,
					),
				);

				\tgmpa( $plugins );
			} );
		}
	}
}
