<?php
namespace Arkfield\Site\Blog;

if ( ! class_exists( __NAMESPACE__ . '\\Blog_Manager' ) ) {
	/**
	 * Class Blog_Manager
	 * @package Arkfield\Site\Blog
	 */
	class Blog_Manager {
		/**
		 * @var Blog_Config
		 */
		private $blog_config;

		/**
		 * Blog_Manager constructor.
		 *
		 * @param Blog_Config $blog_config
		 */
		public function __construct( Blog_Config $blog_config ) {
			$this->blog_config = $blog_config;
		}

		public function setup() {
			$this->register_user_contact_methods();
			$this->register_post_password_form();
		}

		protected function register_user_contact_methods() {
			$blog_config = $this->blog_config;
			\add_filter( 'user_contactmethods', function () use ( $blog_config ) {
				return $blog_config->get_user_contact_methods();
			} );
		}

		protected function register_post_password_form() {
			\add_filter( 'the_password_form', function () {
				$post = $GLOBALS['post'];

				if ( ! \is_single( $post ) ) {
					return '';
				}

				$label       = 'pwbox-' . ( empty( $post->ID ) ? rand() : $post->ID );
				$form_action = \esc_url( \site_url( 'wp-login.php?action=postpass', 'login_post' ) );
				$submit_text = \esc_attr__( 'Submit', 'arkfield' );
				$form_text   = esc_html__(
					'This content is password protected. To view it please enter your password below:',
					'arkfield'
				);

				$output_pattern = '
					<form action="%s" class="post-password-form" method="post">
						<div class="password-form-text">%s</div>
						<input class="password-form" name="post_password" id="%s" type="password" size="20" />
						<input class="pikode pikode--btn btn btn--large btn--gamma"
							type="submit" name="Submit" value="%s" />
					</form>';

				return sprintf(
					$output_pattern,
					$form_action,
					$form_text,
					$label,
					$submit_text
				);
			} );
		}
	}
}