<?php
use Arkfield\Misc\Service;

if ( ! Service::woo_commerce_utils()->is_shop_activated() ) {
	return;
}

$page_builder_section = \Zend_Registry::get( 'page_builder_section' );

$products_speed = (int) ( isset( $page_builder_section['products_speed'] ) && ( 'on' === $page_builder_section['products_speed'] ) );

$products_query_args = array(
	'posts_per_page' => (int) $page_builder_section['nb_products']
);
?>

<article class="page-builder page-builder--products"
         data-items-speed="<?php echo esc_attr( $products_speed ) ?>">
	<div class="page-builder__container">
		<div class="woocommerce-products">
			<?php
			Service::woo_commerce_utils()->get_products_and_process_loop( $products_query_args, function () {
				wc_get_template_part( 'content', 'product' );
			} );
			?>
		</div>
	</div>
</article>
