<?php
use Arkfield\Misc\Service;

$page_builder_section = \Zend_Registry::get( 'page_builder_section' );
$project_dal          = Service::project_dal();
$project_utils        = Service::project_utils();
$projects             = Service::project_dal()->get_projects( $page_builder_section['nb_projects'] );
$projects_speed       = isset( $page_builder_section['projects_speed'] )
	? (int) ( 'on' === $page_builder_section['projects_speed'] ) : 0;

if ( ! empty( $projects ) ) : ?>
	<article class="page-builder page-builder--fullgrid"
	         data-items-speed="<?php echo esc_attr( $projects_speed ) ?>">
		<div class="article__content">
			<div class="mesh mesh--fullgrid">
				<?php
				/* @var WP_Post $project */
				foreach ( $projects as $project_index => $project ) :
					$project_meta    = $project_dal->get_project_meta( $project->ID );
					$meta_title      = isset ( $project_meta['title'] ) ? $project_meta['title'] : '';
					$title           = $project_utils->get_project_title( get_the_title( $project ), $meta_title );
					$meta_subtitle   = isset ( $project_meta['subtitle'] ) ? $project_meta['subtitle'] : '';
					$subtitle        = $project_utils->get_filtered_title( $meta_subtitle );
					$animation_delay = $project_utils->get_full_grid_projects_animation_delay( $project_index );
					?>

					<div class="mesh__item">
						<a class="mesh__item__link" href="<?php echo esc_url( get_permalink( $project ) ); ?>">
							<div class="mesh__item__image animated" data-animation="slideInDown"
							     data-animation-delay="<?php echo esc_attr( $animation_delay ) ?>">
								<?php echo $project_utils->get_project_featured_image_html(
									$project->ID, $title, $project_meta, 'large', array( 'class' => 'img-responsive' ) ) ?>
							</div>
							<div class="mesh__item__header">
								<h2 class="mesh__item__header__title"><?php echo esc_html( $title ) ?></h2>
								<?php if ( ! empty( $subtitle ) ): ?>
									<h6 class="mesh__item__header__subtitle"><?php echo esc_html( $subtitle ) ?></h6>
								<?php endif; ?>
							</div>
						</a>
					</div>

				<?php endforeach; ?>
			</div>
		</div>
	</article>
<?php endif; ?>