<?php
use Arkfield\Misc\Service;

$related_posts = Service::blog_dal()->get_related_posts( get_post()->ID, 5 );

if ( ! empty( $related_posts ) ) : ?>
	<div class="related-posts-wrapper">
		<h5>
			<?php esc_html_e( 'Related posts:', 'arkfield' ); ?>
		</h5>
		<ul class="related-posts">
			<?php foreach ( $related_posts as $related_post ) : ?>
				<li>
					<a href="<?php echo esc_url( get_permalink( $related_post ) ); ?>"
					   title="<?php the_title_attribute( array( 'post' => $related_post ) ); ?>">
						<?php echo get_the_title( $related_post ); ?>
					</a>
				</li>
			<?php endforeach; ?>
		</ul>
	</div>
<?php endif; ?>
