<?php
use Arkfield\Misc\Service;

$project       = \Zend_Registry::get( 'project' );
$project_index = \Zend_Registry::get( 'project_index' );
$project_meta  = Service::project_dal()->get_project_meta( $project->ID );
$project_utils = Service::project_utils();
$title         = $project_utils->get_project_title( get_the_title( $project ), $project_meta['title'] );
$subtitle      = $project_utils->get_filtered_title( $project_meta['subtitle'] );

$item_css_class = ' mesh__item ' . $project_utils->get_project_categories_filter_options( $project );
?>
<div class="<?php echo esc_attr( $item_css_class ) ?>">
	<a class="mesh__item__link" href="<?php echo esc_url( get_permalink( $project ) ); ?>">
		<div class="mesh__item__image animated" data-animation="slideInDown"
		     data-animation-delay="<?php echo esc_attr( $project_utils->get_classic_projects_animation_delay( $project_index ) ) ?>">
			<?php echo $project_utils->get_project_featured_image_html(
				$project->ID, $title, $project_meta, 'large' ) ?>
		</div>
		<div class="mesh__item__header">
			<h2 class="mesh__item__header__title"><?php echo esc_html( $title ) ?></h2>
			<h6 class="mesh__item__header__subtitle"><?php echo esc_html( $subtitle ) ?></h6>
		</div>
	</a>
</div>