<?php
use Arkfield\Misc\Service;

get_header();
the_post();

$project_dal   = Service::project_dal();
$project_utils = Service::project_utils();
$project_meta  = $project_dal->get_project_meta( get_the_ID() );
$gallery_ids   = $project_utils->get_project_gallery_ids( $project_meta );
$meta_title    = isset ( $project_meta['title'] ) ? $project_meta['title'] : '';
$title         = $project_utils->get_project_title( get_the_title(), $meta_title );
$subtitle      = $project_utils->get_filtered_title( isset ( $project_meta['subtitle'] ) ? $project_meta['subtitle'] : '' );
?>

	<!-- Main Area -->
	<main id="site-main" class="site-main site-main--single" role="main">
		<div class="site-main__container">

			<header class="main__header">
				<?php
				if ( ! empty( $gallery_ids ) ):?>
					<article class="page-builder--fullscreen">
						<div class="pikartslider pikartslider--fullscreen">
							<?php foreach ( $gallery_ids as $img_id ):
								echo $project_dal->get_project_image( $img_id, 'full', array( 'class' => 'rsImg' ) ) ?>
							<?php endforeach; ?>
						</div>
					</article>
				<?php endif; ?>

				<h1><?php echo esc_html( $title ) ?></h1>
				<?php if ( ! empty( $subtitle ) ): ?>
					<h5>
						<?php echo esc_html( $subtitle ) ?>
					</h5>
				<?php endif; ?>
			</header>

			<div class="main__content">
				<?php
				the_content();

				Service::utils()->get_partial( 'blog/link-pages' );
				Service::utils()->get_partial( 'project/taxonomies' );
				Service::utils()->get_partial( 'project/related-projects' );
				?>
			</div>

			<footer class="main__footer">

				<?php
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif; ?>

			</footer>

		</div>
	</main>

<?php
get_footer();
