<?php
namespace Arkfield\Admin\MetaBoxes;

if ( ! class_exists( __NAMESPACE__ . '\\Meta_Box_Sanitizer' ) ) {
	/**
	 * Class Meta_Box_Sanitizer
	 * @package Arkfield\Admin\MetaBoxes
	 */
	class Meta_Box_Sanitizer {
		const SANITIZE_METHOD_PATTERN = 'sanitize_%s';
		const DEFAULT_SANITIZE_TYPE = 'text';

		/**
		 * @param mixed  $value
		 * @param string $type
		 *
		 * @return mixed
		 */
		public function sanitize( $value, $type = 'text' ) {
			$sanitize_method = sprintf( self::SANITIZE_METHOD_PATTERN, $type );

			if ( ! method_exists( $this, $sanitize_method ) ) {
				$sanitize_method = sprintf( self::SANITIZE_METHOD_PATTERN, self::DEFAULT_SANITIZE_TYPE );
			}

			return $this->$sanitize_method( $value );
		}

		/**
		 * @param string $text
		 *
		 * @return string
		 */
		public function sanitize_text( $text ) {
			return \sanitize_text_field( $text );
		}

		/**
		 * @param string $text
		 *
		 * @return string
		 */
		public function sanitize_wp_editor( $text ) {
			return \wp_kses_post( $text );
		}
	}
}