<?php
namespace Arkfield\Admin\MetaBoxes\Generator;

use Arkfield\Admin\Pikart_Gallery;

if ( ! class_exists( __NAMESPACE__ . '\\Field_Generator' ) ) {
	/**
	 * Class Field_Generator
	 * @package Arkfield\Admin\MetaBoxes\Generator
	 */
	class Field_Generator {
		const INPUT_PATTERN = '<input type="%s" name="%s" id="%s" value="%s" %s />';
		const INPUT_WITHOUT_VALUE_PATTERN = '<input type="%s" name="%s" id="%s" %s />';
		const BUTTON_PATTERN = '<a id="%s" %s >%s</a>';
		const SELECT_PATTERN = '<select name="%s" id="%s" %s >%s</select>';
		const SELECT_OPTION_PATTERN = '<option value="%s" %s >%s</option>';

		/**
		 * @var Pikart_Gallery
		 */
		protected $pikart_gallery;

		/**
		 * Field_Generator constructor.
		 *
		 * @param Pikart_Gallery $pikart_gallery
		 */
		public function __construct( Pikart_Gallery $pikart_gallery ) {
			$this->pikart_gallery = $pikart_gallery;
			$this->pikart_gallery->setup();
		}


		/**
		 * @param array $field_config
		 *
		 * @return string
		 */
		public function generate_gallery( array $field_config ) {
			return $this->pikart_gallery->generate_gallery_html( $field_config['id'], explode( ',', $field_config['value'] ) );
		}

		/**
		 * @param $field_config
		 *
		 * @return string
		 */
		public function generate_wp_editor( array $field_config ) {
			preg_match( '/^\w+\[(\d+)\].+$/', $field_config['id'], $matches );

			$settings                  = isset( $field_config['editor_settings'] ) ? $field_config['editor_settings'] : '';
			$settings['textarea_name'] = $field_config['id'];

			ob_start();
			\wp_editor( $field_config['value'], 'section_content_' . $matches[1], $settings );
			$content = ob_get_contents();
			ob_end_clean();

			return $content;
		}

		/**
		 * @param $field_config
		 *
		 * @return string
		 */
		public function generate_input( array $field_config ) {
			return sprintf(
				self::INPUT_PATTERN,
				$field_config['type'],
				$field_config['id'],
				$field_config['id'],
				$field_config['value'],
				$field_config['attributes']
			);
		}

		/**
		 * @param array $field_config
		 *
		 * @return string
		 */
		public function generate_button( array $field_config ) {
			return sprintf(
				self::BUTTON_PATTERN,
				$field_config['id'],
				$field_config['attributes'],
				$field_config['title']
			);
		}

		/**
		 * @param array $field_config
		 *
		 * @return string
		 */
		public function generate_checkbox( array $field_config ) {
			$checked = $field_config['value'] === 'on' ? 'checked="checked"' : '';

			return sprintf(
				self::INPUT_WITHOUT_VALUE_PATTERN,
				$field_config['type'],
				$field_config['id'],
				$field_config['id'],
				$field_config['attributes'] . ' ' . $checked
			);
		}

		/**
		 * @param array $field_config
		 *
		 * @return string
		 */
		public function generate_dropdown( array $field_config ) {
			$options = '';

			foreach ( $field_config['options'] as $option => $label ) {
				$selected = $field_config['value'] === $option ? 'selected' : '';
				$options .= sprintf( self::SELECT_OPTION_PATTERN, $option, $selected, $label );
			}

			return sprintf(
				self::SELECT_PATTERN,
				$field_config['id'],
				$field_config['id'],
				$field_config['attributes'],
				$options
			);
		}
	}
}