<?php
namespace Arkfield\Admin\ThemeCustomizer;

if ( ! class_exists( __NAMESPACE__ . '\\Theme_Options_Manager' ) ) {
	/**
	 * Class Theme_Options_Manager
	 * @package Arkfield\Admin\ThemeCustomizer
	 */
	class Theme_Options_Manager {

		/**
		 * @var Theme_Options_Config
		 */
		protected $theme_options_config;

		/**
		 * @var Theme_Options_Utils
		 */
		protected $theme_options_utils;

		/**
		 * @var Theme_Options_Builder
		 */
		protected $theme_options_builder;

		/**
		 * Theme_Options_Manager constructor.
		 *
		 * @param Theme_Options_Config  $theme_options_config
		 * @param Theme_Options_Utils   $theme_options_utils
		 * @param Theme_Options_Builder $theme_options_builder
		 */
		public function __construct(
			Theme_Options_Config $theme_options_config,
			Theme_Options_Utils $theme_options_utils,
			Theme_Options_Builder $theme_options_builder
		) {
			$this->theme_options_config  = $theme_options_config;
			$this->theme_options_utils   = $theme_options_utils;
			$this->theme_options_builder = $theme_options_builder;
		}


		public function run() {
			$this->customizer_register();
			$this->enqueue_scripts();
			$this->customizer_preview_init();
			$this->localize_customizer_data();
		}

		protected function customizer_register() {
			$theme_options_config  = $this->theme_options_config;
			$theme_options_builder = $this->theme_options_builder;
			\add_action( 'customize_register',
				function ( \WP_Customize_Manager $wp_customize_manager ) use ( $theme_options_config, $theme_options_builder ) {

					$options = $theme_options_config->get_options_for_transport_type();

					foreach ( $options as $option ) {
						$wp_customize_manager->get_setting( $option )->transport =
							Theme_Options_Config::DEFAULT_CONTROL_TRANSPORT_TYPE;
					}

					$theme_options_builder->get_theme_options_wrapper()->set_wp_customize_manager( $wp_customize_manager );

					$theme_options_builder->generate_theme_options();
				}, 11 );
		}

		protected function enqueue_scripts() {
			$theme_options_utils = $this->theme_options_utils;
			\add_action( 'wp_enqueue_scripts', function () use ( $theme_options_utils ) {

				\wp_add_inline_style( 'arkfield' . '-theme-style', $theme_options_utils->get_customized_css() );
			}, 11 );
		}

		protected function customizer_preview_init() {
			$theme_options_config = $this->theme_options_config;
			$theme_options_utils  = $this->theme_options_utils;
			\add_action( 'customize_preview_init', function () use ( $theme_options_config, $theme_options_utils ) {
				wp_enqueue_script(
					'arkfield' . '-theme-customizer',
					$theme_options_config->get_theme_customizer_js_file(),
					array( 'customize-preview' ),
					ARKFIELD_THEME_VERSION,
					true
				);

				\wp_localize_script( 'arkfield' . '-theme-customizer', 'arkfield' . 'CustomizerData', array(
					'optionsConfig' => $theme_options_utils->get_customized_js()
				) );
			} );
		}

		protected function localize_customizer_data() {
			$theme_options_utils = $this->theme_options_utils;
			add_action( 'wp_enqueue_scripts', function () use ( $theme_options_utils ) {
				wp_localize_script( 'arkfield' . '-theme-script', 'themeCustomOptions', array(
					'footerWidgetsNbColumns' => $theme_options_utils->get_custom_option( 'footer_widgets_columns' ),
					'projectsLazyLoad'       => $theme_options_utils->get_custom_option( 'projects_lazy_load' ),
					'colors'                 => $theme_options_utils->get_color_options(),
				) );
			} );
		}
	}
}