<?php
namespace Arkfield\Misc;

if ( ! class_exists( __NAMESPACE__ . '\\Utils' ) ) {
	/**
	 * Class Utils
	 * @package Arkfield\Misc
	 */
	class Utils {
		/**
		 * @param string $html
		 *
		 * @return string
		 */
		public function remove_html_outer_tag( $html ) {
			return preg_replace( '/^<[^>]+>|<\/[^>]+>$/', '', $html );
		}

		/**
		 * @param string $text
		 *
		 * @return string
		 */
		public function normalize_meta_value_to_partial_name( $text ) {
			return str_replace( '_', '-', strtolower( $text ) );
		}

		/**
		 * @param string $content
		 *
		 * @return string
		 */
		public function process_content_before_output( $content ) {
			return str_replace( ']]>', ']]&gt;', \apply_filters( 'the_content', $content ) );
		}

		/**
		 * @param array $attributes
		 *
		 * @return string
		 */
		public function html_attributes_to_string( $attributes ) {
			$attributes_list = array();
			foreach ( $attributes as $name => $value ) {
				$attributes_list[] = $name . '="' . $value . '"';
			}

			return implode( ' ', $attributes_list );
		}

		/**
		 * @param string $url
		 * @param bool   $with_extension
		 *
		 * @return string
		 */
		public function get_url_domain( $url, $with_extension = true ) {
			$pieces = parse_url( $url );

			if ( ! isset( $pieces['host'] ) ) {
				return '';
			}

			$domain = $pieces['host'];

			if ( preg_match( '/(?P<domain>[a-z0-9][a-z0-9\-]{1,63}\.[a-z\.]{2,6})$/i', $domain, $matches ) ) {
				$domain = $matches['domain'];
			}

			if ( $with_extension ) {
				return $domain;
			}

			$domain_parts = explode( '.', $domain );

			return $domain_parts[0];
		}

		/**
		 * @param string $slug
		 * @param string $name
		 */
		public function get_partial( $slug, $name = null ) {
			\get_template_part( 'partials/' . $slug, $name );
		}

		/**
		 * @param string $handle
		 */
		public function enqueue_registered_script( $handle ) {
			if ( ! \wp_script_is( $handle, 'enqueued' ) ) {
				\wp_enqueue_script( $handle );
			}
		}

		/**
		 * @param string   $hook
		 * @param callback $function_to_change
		 * @param int      $old_priority
		 * @param int      $new_priority
		 * @param int      $accepted_args
		 */
		public function change_hook_function_priority(
			$hook, $function_to_change, $old_priority = 10, $new_priority = 10, $accepted_args = 1
		) {
			$this->change_function_hook(
				$hook, $hook, $function_to_change, $old_priority, $new_priority, $accepted_args );
		}

		/**
		 * @param string   $old_hook
		 * @param string   $new_hook
		 * @param callback $function_to_change
		 * @param int      $old_priority
		 * @param int      $new_priority
		 * @param int      $accepted_args
		 */
		public function change_function_hook(
			$old_hook, $new_hook, $function_to_change, $old_priority = 10, $new_priority = 10, $accepted_args = 1
		) {
			\remove_filter( $old_hook, $function_to_change, $old_priority );
			\add_filter( $new_hook, $function_to_change, $new_priority, $accepted_args );
		}
	}
}
