<?php
namespace Arkfield\Site\Blog;

use Arkfield\Admin\ThemeCustomizer\Theme_Options_Utils;
use Arkfield\Project\Project_Config;

if ( ! class_exists( __NAMESPACE__ . '\\Blog_Utils' ) ) {
	/**
	 * Class Blog_Utils
	 * @package Arkfield\Site\Blog
	 */
	class Blog_Utils {
		/**
		 * @var Blog_Config
		 */
		private $blog_config;

		/**
		 * @var Blog_DAL
		 */
		private $blog_dal;

		/**
		 * @var Theme_Options_Utils
		 */
		private $theme_options_utils;

		/**
		 * @param Blog_Config         $blog_config
		 * @param Blog_DAL            $blog_dal
		 * @param Theme_Options_Utils $theme_options_utils
		 */
		public function __construct(
			Blog_Config $blog_config, Blog_DAL $blog_dal, Theme_Options_Utils $theme_options_utils
		) {
			$this->blog_config         = $blog_config;
			$this->blog_dal            = $blog_dal;
			$this->theme_options_utils = $theme_options_utils;
		}

		/**
		 * @param int $user_id
		 *
		 * @return array
		 */
		public function get_author_social_network_links( $user_id ) {
			return $this->blog_dal->get_author_social_networks_data(
				$user_id, array_keys( $this->blog_config->get_user_contact_methods() ) );
		}

		/**
		 * @return string
		 */
		public function get_content_title() {
			if ( is_archive() ) {
				return get_the_archive_title();
			}

			if ( is_search() ) {
				return esc_html__( 'Search results', 'arkfield' );
			}

			return $this->theme_options_utils->get_custom_option( 'blog_title' );
		}

		/**
		 * @return string
		 */
		public function get_content_description() {
			if ( is_archive() ) {
				return get_the_archive_description();
			}

			return '';
		}

		/**
		 * Displays the post content on diary page
		 * If the post type is page or project, the excerpt is displayed, otherwise the content
		 */
		public function display_blog_post_content() {
			$post_type = get_post_type();

			if ( is_search() && ( Project_Config::PROJECT_SLUG === $post_type || 'page' === $post_type ) ) {

				the_excerpt();

				return;
			}

			the_content( '' );
		}
	}
}