<?php
use Arkfield\Misc\Service;

$page_builder_section = \Zend_Registry::get( 'page_builder_section' );

$posts_speed = isset( $page_builder_section['posts_speed'] )
	? (int) ( 'on' === $page_builder_section['posts_speed'] ) : 0;

$posts_args = array(
	'posts_per_page' => (int) $page_builder_section['nb_posts'],
	'orderby'        => 'date',
	'order'          => 'DESC',
);
?>

<article class="page-builder page-builder--diary">
	<div class="page-builder__container">
		<div class="news" data-items-speed="<?php echo esc_attr( $posts_speed ) ?>">

			<?php Service::blog_dal()->get_posts_and_process_loop( $posts_args, function () {
				Service::utils()->get_partial( 'blog/content', get_post_format() );
			} ); ?>

		</div>
	</div>
</article>
