<?php
$name         = trim( $name );
$social_links = array(
	'twitter'   => $social_twitter,
	'facebook'  => $social_facebook,
	'linkedin'  => $social_linkedin,
	'pinterest' => $social_pinterest,
);
?>
<div class="pikode  pikode--team-member  team-member  <?php echo esc_attr( $class ) ?>">

	<?php if ( ! empty( $image ) ) : ?>

		<div class="team-member__image">
			<?php if ( ! empty( $imagelink ) ) : ?>

				<a href="<?php echo esc_url( $imagelink ) ?>" class="team-member__image__link"
				   title="More about <?php echo esc_attr( $name ) ?>">
					<div class="team-member__image__container">
						<img src="<?php echo esc_url( $image ); ?>"
						     alt="<?php echo esc_attr( $name ) ?>">
					</div>
				</a>

			<?php else: ?>

				<div class="team-member__image__container">
					<img src="<?php echo esc_url( $image ); ?>"
					     alt="<?php echo esc_attr( $name ) ?>">
				</div>

			<?php endif; ?>
		</div>

	<?php endif; ?>

	<div class="team-member__header">
		<?php if ( ! empty( $name ) ) : ?>
			<h3 class="team-member__name"><?php echo esc_html( $name ); ?></h3>
		<?php endif; ?>
		<?php if ( ! empty( $title ) ) : ?>
			<h6 class="team-member__position"><?php echo esc_html( $title ); ?></h6>
		<?php endif; ?>

		<ul class="team-member__social-links-list">
			<?php foreach ( $social_links as $network_name => $social_link ) :
				if ( ! empty( $social_link ) ) : ?>
					<li class="team-member__social-link">
						<a class="team-member__social-link__link" href="<?php echo esc_url( $social_link ); ?>"
						   target="_blank">
							<i class="shc  shc--icon  icon-<?php echo $network_name ?>"></i>
						</a>
					</li>
					<?php
				endif;
			endforeach; ?>
		</ul>
	</div>
</div>