<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive.
 *
 * Override this template by copying it to yourtheme/woocommerce/archive-product.php
 *
 * @author        WooThemes
 * @package       WooCommerce/Templates
 * @version       2.0.0
 */

use Arkfield\Misc\Service;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>

<main id="site-main" class="site-main site-main--shop">
	<div class="site-main__container">

		<?php
		/**
		 * woocommerce_before_main_content hook
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */
		! is_shop() && do_action( 'woocommerce_before_main_content' );
		?>

		<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>

			<header class="main__header">
				<h1><?php woocommerce_page_title(); ?></h1>

				<?php
				/**
				 * woocommerce_before_shop_loop hook
				 *
				 * @hooked woocommerce_result_count - 20
				 * @hooked woocommerce_catalog_ordering - 30
				 */
				have_posts() && do_action( 'woocommerce_before_shop_loop' );
				?>

			</header>

		<?php endif;

		/**
		 * woocommerce_archive_description hook
		 *
		 * @hooked woocommerce_taxonomy_archive_description - 10
		 * @hooked woocommerce_product_archive_description - 10
		 */
		do_action( 'woocommerce_archive_description' );
		?>

		<?php if ( have_posts() ) :
			$product_subcategories_content = Service::woo_commerce_utils()->capture_product_subcategories_content();

			if ( ! empty( $product_subcategories_content ) ) : ?>

				<div class="mesh__filter mesh__filter--shop">
					<ul class="mesh__filter__options">
						<li>
							<a class="<?php echo( is_shop() ? 'btn--selected' : 'btn--not-selected' ); ?>"
							   href="<?php echo esc_url( get_permalink( wc_get_page_id( 'shop' ) ) ) ?>">
								<?php esc_html_e( 'All', 'arkfield' ) ?>
							</a>
						</li>
						<?php echo $product_subcategories_content ?>
					</ul>
				</div>
			<?php endif;

			woocommerce_product_loop_start();

			while ( have_posts() ) :
				the_post();

				wc_get_template_part( 'content', 'product' );

			endwhile; // end of the loop.

			woocommerce_product_loop_end();

			/**
			 * woocommerce_after_shop_loop hook
			 *
			 * @hooked woocommerce_pagination - 10
			 */
			do_action( 'woocommerce_after_shop_loop' );

		elseif ( ! woocommerce_product_subcategories( array(
			'before' => woocommerce_product_loop_start( false ),
			'after'  => woocommerce_product_loop_end( false )
		) )
		) :

			wc_get_template( 'loop/no-products-found.php' );

		endif;

		/**
		 * woocommerce_after_main_content hook
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );

		/**
		 * woocommerce_sidebar hook
		 *
		 * @hooked woocommerce_get_sidebar - 10
		 */
		do_action( 'woocommerce_sidebar' ); ?>

	</div>
</main>

<?php get_footer( 'shop' ); ?>
