<?php

/**************************************
WIDGET: sport_single_event
***************************************/

	add_action('widgets_init', 'register_widget_sport_single_event' );
	function register_widget_sport_single_event () {
		register_widget('sport_single_event');	
	}

	class sport_single_event extends WP_Widget {

		/**************************************
		1. INIT
		***************************************/
		function __construct () {

				$widget_ops = array(
					'classname' => 'sport_single_event', 								
					'description' => __('Display a single event', "loc_sport_widgets_plugin")	 				
				);
				$control_ops = array(
					'width' => 300, 
					'height' => 350, 
					'id_base' => 'sport_single_event' 														
				);

				$this->WP_Widget('sport_single_event', __('Sport: Single Event', "loc_sport_widgets_plugin"), $widget_ops, $control_ops );	
		}

		/**************************************
		2. UPDATE
		***************************************/
		function update($new_instance, $old_instance) {
			return $new_instance;	 
		}

		/**************************************
		3. FORM
		***************************************/
		function form($instance) {

			//default for checkboxes
			if (empty($instance)) {
				$defaults_checkboxes = array(
					// 'fb_faces' => 'checked'
				);	
			}

			//defaults
			$defaults = array( 
				'widget_title' 		=> __('Event', "loc_sport_widgets_plugin"),
				'excerpt_length' 	=> 650,
			);

			//merge default
			if (!empty($defaults_checkboxes)) $defaults = array_merge($defaults, $defaults_checkboxes);

			$instance = wp_parse_args($instance, $defaults);
			extract($instance);
			?>

				<p>
					<label for="<?php echo $this->get_field_id('widget_title'); ?> "><?php _e("Title", "loc_sport_widgets_plugin"); ?>: </label><br>
					<input type='text' id='<?php echo $this->get_field_id('widget_title'); ?>' name='<?php echo $this->get_field_name('widget_title'); ?>' value="<?php if(isset($widget_title)) echo htmlspecialchars($widget_title); ?>">
				</p>

				<?php 

					// DETECT PLUGIN
					if (!class_exists('TribeEvents')) {
						echo '<p>';
						_e("<i><strong>WARNING:</strong> This block requires <strong>The Events Calendar</strong> plugin. The required plugin could not be found. Please go to plugins and install/activate the required plugin!</i>", "loc_sport_widgets_plugin");
						echo '</p>';
					} else  {
					?>

					<!-- DYNAMIC SELECT -->
						<?php 

							$events = tribe_get_events(array(
								'eventDisplay'		=> 'all',
								'orderby'			=> 'post_date',
								'order'				=> 'DESC',
							));

						 ?>
						<p>
							<label><?php _e("Select event", "loc_sport_widgets_plugin"); ?></label>
							<select name="<?php echo $this->get_field_name('event_ID'); ?>"> 

							<?php 

								if (count($events) === 0) {
									echo "<option value=''>No events found</option>";
										
								} else {
									for ($i = 0; $i < count($events); $i++) { 
									?>
					     				<option value="<?php echo $events[$i]->ID; ?>" <?php if (isset($event_ID)) {if ($event_ID == $events[$i]->ID) echo "selected='selected'";} ?>><?php printf('%s (%s)', esc_attr($events[$i]->post_title), esc_attr(tribe_get_start_date($events[$i]->ID))); ?></option> 
									<?php
									}
										
								}
							?>
							</select> 
						<p>

						
					<?php
					}
				?>

				<p>
					<label for='<?php echo $this->get_field_id('excerpt_length'); ?>'><?php _e("Automatic Excerpt Size", "loc_sport_widgets_plugin"); ?>	: </label><br>
					<input 
						style='width: 80px;'
						type='number' 
						min='0'
						max='10000'
						step='1'
						id='<?php echo $this->get_field_id('excerpt_length'); ?>' 
						name='<?php echo $this->get_field_name('excerpt_length'); ?>' 
						value='<?php if (isset($excerpt_length)) echo esc_attr($excerpt_length); ?>'
					>
				</p>



			<?php	

		}

		/**************************************
		4. DISPLAY
		***************************************/
		function widget($args, $instance) {
			extract($args);								
			extract($instance);

			// DEFAULTS
			if (empty($instance)) {
				$widget_title 		= __('Event', "loc_sport_widgets_plugin");
				$excerpt_length 	= 650;

				// get events
				$events = tribe_get_events(array(
					'eventDisplay'		=> 'all',
					'orderby'			=> 'post_date',
					'order'				=> 'DESC',
					'numberposts'		=> 1,
				));

				$event_ID			= $events[0]->ID;
			}

			$cost = tribe_get_formatted_cost($event_ID);	

            // WPML
            if (function_exists('icl_translate')) { $widget_title = icl_translate('loc_sport_widgets_plugin', "$widget_id-widget[widget_title]", $widget_title); }
            if (function_exists('icl_translate')) { $cost = icl_translate('loc_sport_widgets_plugin', "$widget_id-widget[cost]", $cost); }

			if (!isset($event_ID) || empty($event_ID)) { return; }

			$event = get_post($event_ID);

			?>

			<?php echo $before_widget; ?>

			<?php if (!empty($widget_title)) { echo $before_title . $widget_title . $after_title; } ?>

            	<!-- Start Post --> 
            	<div class="clearfix tribe-events-tcblock">

					<!-- Event Cost -->
					<div class="tribe-events-event-cost">
						<span><?php echo $cost; ?></span>
					</div>

					<!-- Event Title -->
					<h2 class="tribe-events-list-event-title summary">
						<?php printf('<a class="url" href="%s" title="%s" rel="bookmark">%s</a>', esc_url(tribe_get_event_link($event_ID)), esc_attr(get_the_title($event_ID)), esc_attr(get_the_title($event_ID))); ?>
					</h2>
					
					<!-- Event Image -->
					<div class="tribe-events-event-image">
						<?php 

							if ( has_post_thumbnail($event_ID) && get_post(get_post_thumbnail_id($event_ID)) ) {
                                $post_thumbnail_src = wp_get_attachment_image_src(get_post_thumbnail_id($event_ID),'full');
								printf('<a href="%s" title="%s"><img src="%s" title="%s"/></a>', esc_url(tribe_get_event_link($event_ID)), esc_attr(get_the_title($event_ID)), esc_url($post_thumbnail_src[0]), esc_attr(get_the_title($event_ID))); 
							}

						?>

					</div>
					
													
					<!-- Event Meta -->
					<div class="tribe-events-event-meta  vcard location">

						<!-- Schedule & Recurrence Details -->
						<div class="updated published time-details">
							<?php printf('<span class="date-start dtstart">%s</span>', esc_attr(tribe_get_start_date($event_ID))); ?>
						</div>

						<!-- Venue Display Info -->
						<div class="tribe-events-venue-details">

							<span class="author fn org"><?php echo tribe_get_venue($event_ID); ?></span>, 

							<address class="tribe-events-address">
								<span class="adr">
									<span class="street-address"><?php echo tribe_get_address($event_ID); ?></span>
									<span class="delimiter">,</span>  
									<span class="locality"><?php echo tribe_get_city($event_ID); ?></span>
									<span class="delimiter">,</span>  
									<span class="postal-code"><?php echo tribe_get_zip($event_ID); ?></span> 
									<span class="country-name"><?php echo tribe_get_country($event_ID); ?></span>
								</span>
							</address>

							<?php printf('<a class="tribe-events-gmap" href="%s" title="Click to view a Google Map" target="_blank">- Google Map</a>', esc_url(tribe_get_map_link($event_ID))); ?>

						</div> <!-- .tribe-events-venue-details -->

					</div><!-- .tribe-events-event-meta -->

					
					
					<!-- Event Content -->
					<div class="tribe-events-list-event-description tribe-events-content description entry-summary">

						
						<?php 
							$event_excerpt = (!empty($event->post_excerpt)) ? do_shortcode($event->post_excerpt) : mb_make_excerpt($event->post_content, $excerpt_length, true);

							// excerpt
							echo "<p>";
							echo $event_excerpt;
							echo "</p>";

							// read more
							printf('<a href="%s" class="tribe-events-read-more" rel="bookmark">%s &raquo;</a>', esc_url(tribe_get_event_link($event_ID)), esc_attr(__('Find out more', "loc_sport_widgets_plugin")) );

						?>


						
					</div><!-- .tribe-events-list-event-description -->
                 
                </div>

			<?php echo $after_widget; ?>


			<?php
		}

	} //END CLASS



