<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
use Bookly\Backend\Components\Controls\Inputs;
?>
<div ng-hide="form.id" class="mt-3">
    <?php Inputs::renderCheckBox( __( 'Repeat this appointment', 'bookly' ), null, null, array(
        'id' => 'bookly-repeat-enabled',
        'ng-model' => 'form.repeat.enabled',
        'ng-true-value' => '1',
        'ng-false-value' => '0'
    ) ) ?>
</div>

<div ng-show="form.repeat.enabled" class="border-left ml-4 pl-3">
    <div class="mt-3">
        <div class="form-group form-row">
            <div class="col-sm-2 col-form-label">
                <?php esc_html_e( 'Repeat', 'bookly' ) ?>
            </div>
            <div class="col-sm-4">
                <select id="bookly-repeat" class="form-control custom-select" ng-model=form.repeat.repeat ng-change="onRepeatChange()">
                    <option value="daily"><?php esc_html_e( 'Daily', 'bookly' ) ?></option>
                    <option value="weekly"><?php esc_html_e( 'Weekly', 'bookly' ) ?></option>
                    <option value="biweekly"><?php esc_html_e( 'Biweekly', 'bookly' ) ?></option>
                    <option value="monthly"><?php esc_html_e( 'Monthly', 'bookly' ) ?></option>
                </select>
            </div>
        </div>
        <div class="form-group form-row" ng-show="form.repeat.repeat == 'daily'">
            <div class="col-sm-2 col-form-label"><?php esc_html_e( 'Every', 'bookly' ) ?></div>
            <div class="col-sm-4">
                <div class="input-group">
                    <input type="number" id="bookly-repeat-every" step="1" min="1" class="form-control" ng-model=form.repeat.daily.every autocomplete="off" ng-change="onRepeatChange()"/>
                    <div class="input-group-append"><span class="input-group-text"><?php esc_html_e( 'day(s)', 'bookly' ) ?></span></div>
                </div>
            </div>
        </div>
        <div class="form-group form-row" ng-show="form.repeat.repeat == 'weekly' || form.repeat.repeat == 'biweekly'">
            <div class="col-sm-2 col-form-label"><?php esc_html_e( 'On', 'bookly' ) ?></div>
            <div id="bookly-repeat-on" ng-class="{'col-sm-10': true, 'bg-danger': errors.repeat_weekdays_empty}">
                <?php foreach ( $weekdays as $i => $weekday ): ?>
                    <label class="form-check-inline">
                        <?php Inputs::renderCheckBox( $weekday_abbrev[ $i ], $weekday, null, array(
                            'ng-checked' => 'form.repeat.weekly.on.indexOf(\'' . $weekday . '\') > -1',
                            'ng-click'   => 'schOnWeekdayClick(\'' . $weekday . '\')',
                        ) ) ?>
                    </label>
                <?php endforeach ?>
            </div>
        </div>
        <div class="form-group form-row" ng-show="form.repeat.repeat == 'monthly'">
            <div class="col-sm-2 col-form-label"><?php esc_html_e( 'On', 'bookly' ) ?></div>
            <div class="col-sm-4">
                <select class="form-control custom-select" ng-model=form.repeat.monthly.on ng-change="onRepeatChange()">
                    <option value="day"><?php esc_html_e( 'Specific day', 'bookly' ) ?></option>
                    <option value="first"><?php esc_html_e( 'First', 'bookly' ) ?></option>
                    <option value="second"><?php esc_html_e( 'Second', 'bookly' ) ?></option>
                    <option value="third"><?php esc_html_e( 'Third', 'bookly' ) ?></option>
                    <option value="fourth"><?php esc_html_e( 'Fourth', 'bookly' ) ?></option>
                    <option value="last"><?php esc_html_e( 'Last', 'bookly' ) ?></option>
                </select>
            </div>
            <div class="col-sm-2 mr-4" ng-show="form.repeat.monthly.on == 'day'">
                <select id="bookly-repeat-specific-day" class="form-control custom-select" ng-model=form.repeat.monthly.day ng-change="onRepeatChange()">
                    <?php for ( $i = 1; $i <= 31; ++ $i ): ?>
                        <option value="<?php echo $i ?>"><?php echo $i ?></option>
                    <?php endfor ?>
                </select>
            </div>
            <div class="col-sm-2" ng-show="form.repeat.monthly.on != 'day'">
                <select class="form-control custom-select" ng-model=form.repeat.monthly.weekday ng-change="onRepeatChange()">
                    <?php foreach ( $weekdays as $i => $weekday ): ?>
                        <option value="<?php echo $weekday ?>"><?php echo $weekday_abbrev[ $i ] ?></option>
                    <?php endforeach ?>
                </select>
            </div>
        </div>
        <div class="form-group form-row">
            <div class="col-sm-2 col-form-label"><?php esc_html_e( 'Until', 'bookly' ) ?></div>
            <div class="col-sm-4">
                <input date-range-picker type="text" id="bookly-js-repeat-until" class="form-control" autocomplete="off"
                       ng-model=form.repeat.until
                       options="{parentEl:'#bookly-appointment-dialog',singleDatePicker:true,showDropdowns:true,locale:datePickerOptions}"/>
            </div>
            <div class="px-3 mt-2"><?php esc_html_e( 'or', 'bookly' ) ?></div>
            <div class="col-sm-2"><input type="number" step="1" min="1" id="bookly-js-repeat-times" class="form-control" autocomplete="off" ng-model=form.repeat.times ng-change="onRepeatChangeTimes()"/></div>
            <div class="pl-3 mt-2"><?php esc_html_e( 'time(s)', 'bookly' ) ?></div>
        </div>
    </div>
</div>
