<?php
namespace BooklyRecurringAppointments\Lib\Notifications\Booking;

use Bookly\Lib as BooklyLib;
use Bookly\Lib\DataHolders\Booking\Item;
use Bookly\Lib\DataHolders\Booking\Order;
use Bookly\Lib\Notifications\Assets\Item\Codes;
use Bookly\Lib\Notifications\Booking;
use Bookly\Lib\Notifications\Assets\Item\Attachments;

/**
 * Class Sender
 * @package Bookly\Lib\Notifications\Cart
 */
abstract class Sender extends Booking\BaseSender
{
    /**
     * @param BooklyLib\Entities\Notification[] $notifications
     * @param Item  $item
     * @param Order $order
     * @param Codes $codes
     * @param array|bool $queue
     */
    public static function sendSeries( array $notifications, Item $item, Order $order, Codes $codes, &$queue = false )
    {
        $recurring_notifications = array();
        foreach ( $notifications as $notification ) {
            if ( in_array( $notification->getType(), array( BooklyLib\Entities\Notification::TYPE_NEW_BOOKING_RECURRING, BooklyLib\Entities\Notification::TYPE_CUSTOMER_APPOINTMENT_STATUS_CHANGED_RECURRING ) ) ) {
                $recurring_notifications[] = $notification;
            }
        }

        if ( $recurring_notifications ) {
            $reply_to = null;
            if ( get_option( 'bookly_email_reply_to_customers' ) ) {
                $customer = $order->getCustomer();
                $reply_to = array( 'email' => $customer->getEmail(), 'name' => $customer->getFullName() );
            }
            $sent_to_staff = array();
            foreach ( $item->getItems() as $co ) {
                foreach ( $co->getItems() as $simple ) {
                    $staff_id = $simple->getStaff()->getId();
                    if ( ! in_array( $staff_id, $sent_to_staff ) ) {
                        $codes->prepareForItem( $item, 'staff', $simple->getStaff() );
                        $sent_to_staff[]  = $staff_id;
                        $attachments      = new Attachments( $codes );
                        foreach ( $recurring_notifications as $notification ) {
                            if ( $notification
                                ->getSettingsObject()
                                ->allowedServiceWithStatus( $co->getService(), $co->getCA()->getStatus() )
                            ) {
                                static::sendToStaff( $simple->getStaff(), $notification, $codes, $attachments, $reply_to, $queue );
                                static::sendToAdmins( $notification, $codes, $attachments, $reply_to, $queue );
                            }
                        }
                        if ( $queue === false ) {
                            $attachments->clear();
                        }
                    }
                }
            }
        }
    }
}