(function ($) {
    window.booklyStaffCalendar = function (Options) {
        var options = {
            calendar : {
                headerToolbar: {
                    start: 'prev,next today',
                    center: 'title',
                    end: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek'
                },
                view: 'dayGridMonth'
            },
            getCurrentStaffId: function () {
                return Options.staff_id;
            },
            l10n: BooklySCCalendarL10n,
            is_backend: false
        };

        // Init EventCalendar.
        let calendar = new BooklyCalendar($('.bookly-js-calendar'), options);

        // Export to CSV modal
        let $export_dialog = $('#bookly-js-export-dialog');
        $('.bookly-js-export-btn').click(function () {
            $export_dialog.booklyModal('show');
        });

        $export_dialog.find('form').on('submit', function () {
            $export_dialog.booklyModal('hide');
        });

        $export_dialog.on('show.bs.modal', function () {
            let calendar_view = calendar.ec.view;
            $('.bookly-js-export-start').val(moment(calendar_view.activeStart).format('YYYY-MM-DD'));
            $('.bookly-js-export-end').val(moment(calendar_view.activeEnd).format('YYYY-MM-DD'));
        });
    }
})(jQuery);