<?php
namespace BooklyStaffCabinet\Frontend\Modules\StaffDetails;

use Bookly\Lib as BooklyLib;
use BooklyStaffCabinet\Lib;
use BooklyStaffCabinet\Frontend\Components as FrontendComponents;

/**
 * Class ShortCode
 * @package BooklyStaffCabinet\Frontend\Modules\StaffDetails
 */
class ShortCode extends BooklyLib\Base\Component
{
    /**
     * Init component.
     */
    public static function init()
    {
        // Register short code.
        add_shortcode( 'bookly-staff-details', array( __CLASS__, 'render' ) );

        // Assets.
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'linkStyles' ) );
        add_action( 'wp_enqueue_scripts', array( __CLASS__, 'linkScripts' ) );
    }

    /**
     * Link styles.
     */
    public static function linkStyles()
    {
        if (
            get_option( 'bookly_gen_link_assets_method' ) == 'enqueue' ||
            BooklyLib\Utils\Common::postsHaveShortCode( 'bookly-staff-details' )
        ) {
            $bookly_ver = BooklyLib\Plugin::getVersion();
            $bookly_url = plugins_url( '', BooklyLib\Plugin::getMainFile() );
            $cabinet    = plugins_url( '', Lib\Plugin::getMainFile() );

            wp_enqueue_style( 'bookly-ladda.min.css', $bookly_url . '/frontend/resources/css/ladda.min.css', array(), $bookly_ver );
            wp_enqueue_style( 'bookly-bootstrap.min.css', $bookly_url . '/backend/resources/bootstrap/css/bootstrap.min.css', array(), $bookly_ver );
            wp_enqueue_style( 'bookly-staff-cabinet.css', $cabinet  . '/frontend/resources/css/staff-cabinet.css', array( 'bookly-bootstrap.min.css' ), Lib\Plugin::getVersion() );
            if ( get_option( 'bookly_cst_phone_default_country' ) != 'disabled' ) {
                wp_enqueue_style( 'bookly-intlTelInput.css', $bookly_url . '/frontend/resources/css/intlTelInput.css', array(), $bookly_ver );
            }
        }
    }

    /**
     * Link scripts.
     */
    public static function linkScripts()
    {
        if (
            get_option( 'bookly_gen_link_assets_method' ) == 'enqueue' ||
            BooklyLib\Utils\Common::postsHaveShortCode( 'bookly-staff-details' )
        ) {
            $bookly_ver = BooklyLib\Plugin::getVersion();
            $bookly_url = plugins_url( '', BooklyLib\Plugin::getMainFile() );
            $cabinet    = plugins_url( '', Lib\Plugin::getMainFile() );

            wp_enqueue_script( 'bookly-spin.min.js',      $bookly_url . '/frontend/resources/js/spin.min.js',  array(), $bookly_ver );
            wp_enqueue_script( 'bookly-ladda.min.js',     $bookly_url . '/frontend/resources/js/ladda.min.js', array( 'bookly-spin.min.js' ), $bookly_ver );
            wp_enqueue_script( 'bookly-bootstrap.min.js', $bookly_url . '/backend/resources/bootstrap/js/bootstrap.min.js', array( 'jquery' ), $bookly_ver );
            wp_enqueue_script( 'bookly-staff-details.js', $bookly_url . '/backend/components/dialogs/staff/edit/resources/js/staff-details.js', array( 'jquery', 'bookly-dropdown.js' ), $bookly_ver );
            wp_enqueue_script( 'bookly-dropdown.js',  $bookly_url . '/backend/resources/js/dropdown.js', array( 'jquery' ), $bookly_ver );
            wp_enqueue_script( 'bookly-staff-cabinet-native.js', $cabinet  . '/frontend/resources/js/staff-cabinet-native.js', array(), Lib\Plugin::getVersion() );
            wp_enqueue_script( 'bookly-staff-cabinet-details.js', $cabinet  . '/frontend/modules/staff_details/resources/js/staff-cabinet-details.js', array( 'bookly-staff-details.js', 'bookly-staff-cabinet-native.js' ), Lib\Plugin::getVersion() );
            if ( get_option( 'bookly_cst_phone_default_country' ) != 'disabled' ) {
                wp_enqueue_script( 'bookly-intlTelInput.min.js', $bookly_url . '/frontend/resources/js/intlTelInput.min.js', array( 'jquery' ), $bookly_ver );
            }

            wp_localize_script( 'bookly-staff-cabinet-details.js', 'BooklySCDetailsL10n', array(
                'selector'     => array( 'all_selected' => __( 'All locations', 'bookly' ), 'nothing_selected' => __( 'No locations selected', 'bookly' ), ),
                'saved'        => __( 'Settings saved.', 'bookly' ),
                'intlTelInput' => array(
                    'enabled' => get_option( 'bookly_cst_phone_default_country' ) != 'disabled',
                    'utils'   => $bookly_url . '/frontend/resources/js/intlTelInput.utils.js',
                    'country' => get_option( 'bookly_cst_phone_default_country' ),
                ),
                'csrf_token'   => BooklyLib\Utils\Common::getCsrfToken(),
            ) );
        }
    }

    /**
     * Render Staff Details shortcode.
     *
     * @param array $attributes
     * @return string
     */
    public static function render( $attributes )
    {
        // Disable caching.
        BooklyLib\Utils\Common::noCache();

        if ( is_user_logged_in() && $staff = BooklyLib\Entities\Staff::query()->select( 'id, visibility' )->where( 'wp_user_id', get_current_user_id() )->fetchRow() ) {
            \BooklyPro\Backend\Components\License\Components::renderLicenseNotice( false );
            if ( $staff['visibility'] == 'archive' ) {
                return FrontendComponents\Notice\Permission::generateAccountDisabled();
            }
            return \BooklyPro\Lib\Config::graceExpired()
                ? null
                : self::renderTemplate( 'short_code', array( 'form_id' => uniqid( 'details-' ), 'attributes' => $attributes ), false );
        }

        return FrontendComponents\Notice\Permission::generate();
    }
}